/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.formatter.libs.net.dzikoysk.cdn;

import com.eternalcode.formatter.libs.net.dzikoysk.cdn.CdnException;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.CdnReader;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.CdnSettings;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.CdnWriter;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.model.Configuration;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.model.Element;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.model.Section;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.serdes.CdnDeserializer;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.serdes.CdnSerializer;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.source.Output;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.source.Source;
import com.eternalcode.formatter.libs.panda.std.Result;
import org.jetbrains.annotations.NotNull;

public final class Cdn {
    private final CdnSettings settings;

    Cdn(CdnSettings settings) {
        this.settings = settings;
    }

    public static CdnSettings configure() {
        return new CdnSettings();
    }

    public Result<Configuration, CdnException> load(@NotNull Source source) {
        return new CdnReader(this.settings).read(source).mapErr(CdnException.identity());
    }

    public <T> Result<T, CdnException> load(@NotNull Source source, @NotNull Class<T> configurationClass) {
        return this.load(source).flatMap(entity -> new CdnDeserializer<Class>(this.settings).deserialize((Section)entity, configurationClass));
    }

    public <T> Result<T, CdnException> load(@NotNull Source source, @NotNull T instance) {
        return this.load(source).flatMap(entity -> new CdnDeserializer<Object>(this.settings).deserialize((Section)entity, instance));
    }

    public Result<String, CdnException> render(@NotNull Object entity) {
        return new CdnSerializer(this.settings).serialize(entity).flatMap(this::render);
    }

    public Result<String, CdnException> render(@NotNull Object entity, @NotNull Output output) {
        return this.render(entity).flatMap(result -> output.save((String)result).mapErr(CdnException::new));
    }

    public Result<String, CdnException> render(@NotNull Element<?> element) {
        return new CdnWriter(this.settings).render(element);
    }

    public Result<String, CdnException> render(@NotNull Element<?> element, @NotNull Output output) {
        return this.render(element).flatMap(result -> output.save((String)result).mapErr(CdnException::new));
    }

    public CdnSettings getSettings() {
        return this.settings;
    }
}

