/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.formatter.libs.com.eternalcode.gitcheck.git;

import com.eternalcode.formatter.libs.com.eternalcode.gitcheck.shared.Preconditions;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class GitRepository {
    private static final String FULL_NAME_FORMAT = "%s/%s";
    private final String owner;
    private final String name;

    private GitRepository(@NotNull String owner, @NotNull String name) {
        Preconditions.notNull(owner, "owner");
        Preconditions.notNull(name, "name");
        Preconditions.notEmpty(owner, "owner");
        Preconditions.notEmpty(name, "name");
        this.owner = owner;
        this.name = name;
    }

    @NotNull
    public String getOwner() {
        return this.owner;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getFullName() {
        return String.format(FULL_NAME_FORMAT, this.owner, this.name);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof GitRepository)) {
            return false;
        }
        GitRepository that = (GitRepository)object;
        return this.owner.equals(that.owner) && this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(this.owner, this.name);
    }

    public static GitRepository of(@NotNull String owner, @NotNull String name) {
        return new GitRepository(owner, name);
    }
}

