/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.formatter.legacy;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.jetbrains.annotations.VisibleForTesting;

public final class Legacy {
    private static final Pattern COLOR_LEGACY_PATTERN = Pattern.compile("(?i)&([0-9A-FK-ORX#])");
    private static final Pattern HEX_LEGACY_PATTERN = Pattern.compile("(?i)&#([0-9A-F]{6})");
    private static final Pattern HEX_LEGACY_VANILLA_PATTERN = Pattern.compile("(?i)&x(&[0-9A-F]){6}");
    private static final Set<Character> COLORS = Set.of(Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'), Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('f'));
    private static final Set<Character> DECORATIONS = Set.of(Character.valueOf('k'), Character.valueOf('l'), Character.valueOf('m'), Character.valueOf('n'), Character.valueOf('o'));
    private static final Map<Character, String> codeTranslations = new ImmutableMap.Builder().put((Object)Character.valueOf('0'), (Object)"<black>").put((Object)Character.valueOf('1'), (Object)"<dark_blue>").put((Object)Character.valueOf('2'), (Object)"<dark_green>").put((Object)Character.valueOf('3'), (Object)"<dark_aqua>").put((Object)Character.valueOf('4'), (Object)"<dark_red>").put((Object)Character.valueOf('5'), (Object)"<dark_purple>").put((Object)Character.valueOf('6'), (Object)"<gold>").put((Object)Character.valueOf('7'), (Object)"<gray>").put((Object)Character.valueOf('8'), (Object)"<dark_gray>").put((Object)Character.valueOf('9'), (Object)"<blue>").put((Object)Character.valueOf('a'), (Object)"<green>").put((Object)Character.valueOf('b'), (Object)"<aqua>").put((Object)Character.valueOf('c'), (Object)"<red>").put((Object)Character.valueOf('d'), (Object)"<light_purple>").put((Object)Character.valueOf('e'), (Object)"<yellow>").put((Object)Character.valueOf('f'), (Object)"<white>").put((Object)Character.valueOf('k'), (Object)"<obfuscated>").put((Object)Character.valueOf('l'), (Object)"<bold>").put((Object)Character.valueOf('m'), (Object)"<strikethrough>").put((Object)Character.valueOf('n'), (Object)"<underlined>").put((Object)Character.valueOf('o'), (Object)"<italic>").put((Object)Character.valueOf('r'), (Object)"<reset>").build();
    private static final Map<Character, String> legacyCodeToPermission = new ImmutableMap.Builder().put((Object)Character.valueOf('0'), (Object)"chatformatter.color.black").put((Object)Character.valueOf('1'), (Object)"chatformatter.color.dark_blue").put((Object)Character.valueOf('2'), (Object)"chatformatter.color.dark_green").put((Object)Character.valueOf('3'), (Object)"chatformatter.color.dark_aqua").put((Object)Character.valueOf('4'), (Object)"chatformatter.color.dark_red").put((Object)Character.valueOf('5'), (Object)"chatformatter.color.dark_purple").put((Object)Character.valueOf('6'), (Object)"chatformatter.color.gold").put((Object)Character.valueOf('7'), (Object)"chatformatter.color.gray").put((Object)Character.valueOf('8'), (Object)"chatformatter.color.dark_gray").put((Object)Character.valueOf('9'), (Object)"chatformatter.color.blue").put((Object)Character.valueOf('a'), (Object)"chatformatter.color.green").put((Object)Character.valueOf('b'), (Object)"chatformatter.color.aqua").put((Object)Character.valueOf('c'), (Object)"chatformatter.color.red").put((Object)Character.valueOf('d'), (Object)"chatformatter.color.light_purple").put((Object)Character.valueOf('e'), (Object)"chatformatter.color.yellow").put((Object)Character.valueOf('f'), (Object)"chatformatter.color.white").put((Object)Character.valueOf('k'), (Object)"chatformatter.decorations.obfuscated").put((Object)Character.valueOf('l'), (Object)"chatformatter.decorations.bold").put((Object)Character.valueOf('m'), (Object)"chatformatter.decorations.strikethrough").put((Object)Character.valueOf('n'), (Object)"chatformatter.decorations.underlined").put((Object)Character.valueOf('o'), (Object)"chatformatter.decorations.italic").put((Object)Character.valueOf('r'), (Object)"chatformatter.reset").build();

    private Legacy() {
    }

    @VisibleForTesting
    static String clearSection(String text) {
        return text.replace('\u00a7', '&');
    }

    public static String legacyToAdventure(String input) {
        return Legacy.legacyToAdventure(input, permission -> true);
    }

    public static String legacyToAdventure(String input, Predicate<String> hasPermission) {
        String result = Legacy.clearSection(input);
        result = HEX_LEGACY_VANILLA_PATTERN.matcher(result).replaceAll(matchResult -> {
            String hexColor = matchResult.group().replace("&x", "").replace("&", "");
            return "<#" + hexColor + ">";
        });
        result = HEX_LEGACY_PATTERN.matcher(result).replaceAll(matchResult -> {
            String hex = matchResult.group(1);
            return "<#" + hex + ">";
        });
        result = COLOR_LEGACY_PATTERN.matcher(result).replaceAll(matchResult -> {
            char color = matchResult.group(1).toLowerCase().charAt(0);
            String adventure = codeTranslations.get(Character.valueOf(color));
            if (adventure != null && Legacy.hasPermissionForLegacyCode(hasPermission, color)) {
                return adventure;
            }
            return "&" + color;
        });
        return result;
    }

    private static boolean hasPermissionForLegacyCode(Predicate<String> hasPermission, char code) {
        if (hasPermission.test("chatformatter.*")) {
            return true;
        }
        if (COLORS.contains(Character.valueOf(code)) && hasPermission.test("chatformatter.color.*")) {
            return true;
        }
        if (DECORATIONS.contains(Character.valueOf(code)) && hasPermission.test("chatformatter.decorations.*")) {
            return true;
        }
        String permission = legacyCodeToPermission.get(Character.valueOf(code));
        return permission != null && hasPermission.test(permission);
    }
}

