/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.formatter.config;

import com.eternalcode.formatter.ChatSettings;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.entity.Description;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.entity.Descriptions;
import com.eternalcode.formatter.template.Template;
import com.eternalcode.formatter.template.TemplateRepository;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;

public class PluginConfig
implements ChatSettings,
TemplateRepository {
    @Descriptions(value={@Description(value={" "}), @Description(value={"#    ____ _           _   _____      ChatFormatter       _   _            "}), @Description(value={"#   / ___| |__   __ _| |_|  ___|__  _ __ _ __ ___   __ _| |_| |_ ___ _ __ "}), @Description(value={"#  | |   | '_ \\ / _` | __| |_ / _ \\| '__| '_ ` _ \\ / _` | __| __/ _ \\ '__|"}), @Description(value={"#  | |___| | | | (_| | |_|  _| (_) | |  | | | | | | (_| | |_| ||  __/ |   "}), @Description(value={"#   \\____|_| |_|\\__,_|\\__|_|  \\___/|_|  |_| |_| |_|\\__,_|\\__|\\__\\___|_|   "}), @Description(value={" "}), @Description(value={" ", "# Do you want to receive updates about new versions of ChatFormatter?"})})
    public boolean receiveUpdates = true;
    @Descriptions(value={@Description(value={" ", "# Chat format for ranks (Vault) Support mini-messages and legacy colors"}), @Description(value={" ", "# We're recommending to use webui for mini-messages: https://webui.adventure.kyori.net/"}), @Description(value={" ", "# documentation is here: https://docs.adventure.kyori.net/minimessage/format.html"}), @Description(value={" ", "# You can check LuckPerms setup and placeholders here: https://luckperms.net/wiki/Placeholders"}), @Description(value={"# ", "# Example usages:", "# ", "# Hover message:", "# One line: <hover:show_text:'<red>test'>TEST", "# Multiple lines: <hover:show_text:'<red>test'>Test<newline>Test2</hover>", "# ", "# Click message:", "# Open URL: <click:open_url:'https://webui.adventure.kyori.net'>TEST</click>", "# Run command: <click:run_command:/say hello>Click</click> to say hello", "# Suggest command: <click:suggest_command:'/msg {displayname}'></click>", "# ", "# RGB and gradient message usage: ", "# <color:#ff00ee>Example message</color>", "# <gradient:#ff00ee:#f79459>Example message</gradient>", "# ", "# You can use three more internal placeholders: <displayname> <name> <message>", "# "})})
    public String defaultFormat = "{displayname} \u00bb {message}";
    @Description(value={" ", "# Here you can set different formats for each rank.", "# Remember! Rank name must be exactly the same as in you permission plugin configuration.", "# If player have more than one rank remember to correctly setup rank weight configuration"})
    public Map<String, String> format = new ImmutableMap.Builder().put((Object)"default", (Object)"{member} &7$hoverName({displayname}) &8\u00bb <gradient:#d4d4d4:white>{message} ").put((Object)"vip", (Object)"{vip} &f$hoverName({displayname}) <dark_gray>\u00bb <gradient:#ffd270:white>{message}").put((Object)"mod", (Object)"{mod} &f$hoverName({displayname}) <dark_gray>\u00bb <gradient:#a3ff9e:white>{message}").put((Object)"admin", (Object)"{admin} &f$hoverName({displayname}) <dark_gray>\u00bb <gradient:#bac8ff:white><b>{message}").put((Object)"owner", (Object)"{owner} &f$hoverName({displayname}) <dark_gray>\u00bb <gradient:#ff9195:white><b>{message}").build();
    @Description(value={" ", "# Placeholders, it allows you to make a shorter text, you can use some prefixes, characters etc. ", "# You can use here PAPI placeholders."})
    public Map<String, String> placeholders = new ImmutableMap.Builder().put((Object)"{displayname}", (Object)"<displayname>").put((Object)"{name}", (Object)"<name>").put((Object)"{message}", (Object)"<message>").put((Object)"{member}", (Object)"<#6e6764>Member").put((Object)"{vip}", (Object)"<gold>VIP").put((Object)"{mod}", (Object)"<b><#00c900>Mod</b>").put((Object)"{admin}", (Object)"<b><#6e86ff>Admin</b>").put((Object)"{owner}", (Object)"<b><gradient:#c40000:#e04b4b>Owner</b>").put((Object)"{rankDescription}", (Object)"<dark_gray>Rank: <white>%vault_group%").put((Object)"{joinDate}", (Object)"<dark_gray>Joined: <white>%player_first_join_date%").put((Object)"{health}", (Object)"<dark_gray>Health: <red>%player_health%").put((Object)"{lvl}", (Object)"<dark_gray>LVL: <gold>%player_level%").put((Object)"{privateMessage}", (Object)"<gradient:#36ff39:#75ff75><i>Click to send private message</i></gradient>").build();
    @Description(value={" ", "# This section is made for experienced users", "# It is used to shorten the text even more and keep the clean file!"})
    public List<Template> templates = new ImmutableList.Builder().add((Object)Template.of("hoverName", List.of("name"), "<hover:show_text:'<dark_gray>Name: <white>$name<br><br>{rankDescription}<br>{joinDate}<br>{health}<br>{lvl}<br><br>{privateMessage}'><click:suggest_command:'/msg {displayname} '>{displayname}</click></hover>")).build();

    @Override
    public boolean isReceiveUpdates() {
        return this.receiveUpdates;
    }

    @Override
    public String getRawFormat(String rank) {
        return this.format.getOrDefault(rank, this.defaultFormat);
    }

    @Override
    public List<Template> getTemplates() {
        return this.templates;
    }
}

