/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.formatter.config;

import com.eternalcode.formatter.config.PluginConfig;
import com.eternalcode.formatter.config.TemplateComposer;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.Cdn;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.CdnFactory;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.source.Output;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.source.Resource;
import com.eternalcode.formatter.libs.net.dzikoysk.cdn.source.Source;
import com.eternalcode.formatter.template.Template;
import java.io.File;

public class ConfigManager {
    private final Cdn cdn = CdnFactory.createYamlLike().getSettings().withComposer(Template.class, new TemplateComposer()).build();
    private final PluginConfig pluginConfig = new PluginConfig();
    private final File dataFolder;

    public ConfigManager(File dataFolder) {
        this.dataFolder = dataFolder;
    }

    public void loadAndRenderConfigs() {
        this.loadAndRender(this.pluginConfig, "config.yml");
    }

    public <T> void loadAndRender(T config, String file) {
        Resource resource = Source.of(this.dataFolder, file);
        this.cdn.load((Source)resource, config).orThrow(RuntimeException::new);
        this.cdn.render(config, (Output)resource).orThrow(RuntimeException::new);
    }

    public PluginConfig getPluginConfig() {
        return this.pluginConfig;
    }
}

