/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.formatter.adventure;

import com.eternalcode.formatter.libs.net.kyori.adventure.text.format.NamedTextColor;
import com.eternalcode.formatter.libs.net.kyori.adventure.text.format.Style;
import com.eternalcode.formatter.libs.net.kyori.adventure.text.format.TextColor;
import com.eternalcode.formatter.libs.net.kyori.adventure.text.minimessage.Context;
import com.eternalcode.formatter.libs.net.kyori.adventure.text.minimessage.ParsingException;
import com.eternalcode.formatter.libs.net.kyori.adventure.text.minimessage.internal.serializer.SerializableResolver;
import com.eternalcode.formatter.libs.net.kyori.adventure.text.minimessage.internal.serializer.StyleClaim;
import com.eternalcode.formatter.libs.net.kyori.adventure.text.minimessage.tag.Tag;
import com.eternalcode.formatter.libs.net.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import com.eternalcode.formatter.libs.net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public class TextColorTagResolver
implements TagResolver,
SerializableResolver.Single {
    private static final String COLOR_3 = "c";
    private static final String COLOR_2 = "colour";
    private static final String COLOR = "color";
    private static final StyleClaim<TextColor> STYLE = StyleClaim.claim("color", Style::color, (color, emitter) -> {
        if (color instanceof NamedTextColor) {
            emitter.tag(NamedTextColor.NAMES.key((NamedTextColor)color));
        }
    });
    private static final Map<String, TextColor> COLOR_ALIASES = new HashMap<String, TextColor>();
    private final Set<TextColor> allowedColors = new HashSet<TextColor>();

    private static boolean isColorOrAbbreviation(String name) {
        return name.equals(COLOR) || name.equals(COLOR_2) || name.equals(COLOR_3);
    }

    private TextColorTagResolver(Collection<NamedTextColor> allowedColors) {
        this.allowedColors.addAll(allowedColors);
    }

    @Override
    @Nullable
    public Tag resolve(@NotNull String name, @NotNull ArgumentQueue args, @NotNull Context ctx) throws ParsingException {
        if (!this.has(name)) {
            return null;
        }
        String colorName = TextColorTagResolver.isColorOrAbbreviation(name) ? args.popOr("Expected to find a color parameter: <name>|#RRGGBB").lowerValue() : name;
        TextColor color = TextColorTagResolver.resolveColor(colorName, ctx);
        if (!this.allowedColors.contains(color)) {
            throw ctx.newException(String.format("Color '%s' is not allowed.", colorName));
        }
        return Tag.styling(color);
    }

    @NotNull
    static TextColor resolveColor(@NotNull String colorName, @NotNull Context ctx) throws ParsingException {
        TextColor textColor = COLOR_ALIASES.get(colorName);
        if (textColor != null) {
            return textColor;
        }
        textColor = NamedTextColor.NAMES.value(colorName);
        if (textColor != null) {
            return textColor;
        }
        throw ctx.newException(String.format("Unable to parse a color from '%s'. Please use named colours or hex (#RRGGBB) colors.", colorName));
    }

    @Override
    public boolean has(@NotNull String name) {
        if (TextColorTagResolver.isColorOrAbbreviation(name)) {
            return true;
        }
        NamedTextColor textColor = NamedTextColor.NAMES.value(name);
        if (textColor != null && this.allowedColors.contains(textColor)) {
            return true;
        }
        return COLOR_ALIASES.containsKey(name);
    }

    @Override
    @Nullable
    public StyleClaim<?> claimStyle() {
        return STYLE;
    }

    public static TextColorTagResolver of(NamedTextColor ... allowedColors) {
        return new TextColorTagResolver(Arrays.asList(allowedColors));
    }

    static {
        COLOR_ALIASES.put("dark_grey", NamedTextColor.DARK_GRAY);
        COLOR_ALIASES.put("grey", NamedTextColor.GRAY);
    }
}

