/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.formatter;

import com.eternalcode.formatter.ChatHandler;
import com.eternalcode.formatter.ChatMessage;
import com.eternalcode.formatter.ChatRenderedMessage;
import com.eternalcode.formatter.ChatSettings;
import com.eternalcode.formatter.adventure.AdventureUrlPostProcessor;
import com.eternalcode.formatter.adventure.TextColorTagResolver;
import com.eternalcode.formatter.legacy.Legacy;
import com.eternalcode.formatter.libs.net.kyori.adventure.text.Component;
import com.eternalcode.formatter.libs.net.kyori.adventure.text.format.NamedTextColor;
import com.eternalcode.formatter.libs.net.kyori.adventure.text.format.TextDecoration;
import com.eternalcode.formatter.libs.net.kyori.adventure.text.minimessage.MiniMessage;
import com.eternalcode.formatter.libs.net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import com.eternalcode.formatter.libs.net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import com.eternalcode.formatter.libs.net.kyori.adventure.text.minimessage.tag.standard.StandardTags;
import com.eternalcode.formatter.libs.net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import com.eternalcode.formatter.libs.net.kyori.adventure.text.serializer.json.JSONOptions;
import com.eternalcode.formatter.libs.net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import com.eternalcode.formatter.placeholder.PlaceholderRegistry;
import com.eternalcode.formatter.rank.ChatRankProvider;
import com.eternalcode.formatter.template.TemplateService;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import org.bukkit.entity.Player;

class ChatHandlerImpl
implements ChatHandler {
    private static final String PERMISSION_ALL = "chatformatter.*";
    private static final Map<String, TagResolver> TAG_RESOLVERS_BY_PERMISSION = new ImmutableMap.Builder().put((Object)"chatformatter.decorations.*", (Object)StandardTags.decorations()).put((Object)"chatformatter.decorations.bold", (Object)StandardTags.decorations(TextDecoration.BOLD)).put((Object)"chatformatter.decorations.italic", (Object)StandardTags.decorations(TextDecoration.ITALIC)).put((Object)"chatformatter.decorations.underlined", (Object)StandardTags.decorations(TextDecoration.UNDERLINED)).put((Object)"chatformatter.decorations.strikethrough", (Object)StandardTags.decorations(TextDecoration.STRIKETHROUGH)).put((Object)"chatformatter.decorations.obfuscated", (Object)StandardTags.decorations(TextDecoration.OBFUSCATED)).put((Object)"chatformatter.reset", (Object)StandardTags.reset()).put((Object)"chatformatter.newline", (Object)StandardTags.newline()).put((Object)"chatformatter.shadow", (Object)StandardTags.shadowColor()).put((Object)"chatformatter.gradient", (Object)StandardTags.gradient()).put((Object)"chatformatter.rainbow", (Object)StandardTags.rainbow()).put((Object)"chatformatter.pride", (Object)StandardTags.pride()).put((Object)"chatformatter.transition", (Object)StandardTags.transition()).put((Object)"chatformatter.hover", (Object)StandardTags.hoverEvent()).put((Object)"chatformatter.click", (Object)StandardTags.clickEvent()).put((Object)"chatformatter.insertion", (Object)StandardTags.insertion()).put((Object)"chatformatter.color.*", (Object)StandardTags.color()).put((Object)"chatformatter.color.black", (Object)TextColorTagResolver.of(NamedTextColor.BLACK)).put((Object)"chatformatter.color.dark_blue", (Object)TextColorTagResolver.of(NamedTextColor.DARK_BLUE)).put((Object)"chatformatter.color.dark_green", (Object)TextColorTagResolver.of(NamedTextColor.DARK_GREEN)).put((Object)"chatformatter.color.dark_aqua", (Object)TextColorTagResolver.of(NamedTextColor.DARK_AQUA)).put((Object)"chatformatter.color.dark_red", (Object)TextColorTagResolver.of(NamedTextColor.DARK_RED)).put((Object)"chatformatter.color.dark_purple", (Object)TextColorTagResolver.of(NamedTextColor.DARK_PURPLE)).put((Object)"chatformatter.color.gold", (Object)TextColorTagResolver.of(NamedTextColor.GOLD)).put((Object)"chatformatter.color.gray", (Object)TextColorTagResolver.of(NamedTextColor.GRAY)).put((Object)"chatformatter.color.dark_gray", (Object)TextColorTagResolver.of(NamedTextColor.DARK_GRAY)).put((Object)"chatformatter.color.blue", (Object)TextColorTagResolver.of(NamedTextColor.BLUE)).put((Object)"chatformatter.color.green", (Object)TextColorTagResolver.of(NamedTextColor.GREEN)).put((Object)"chatformatter.color.aqua", (Object)TextColorTagResolver.of(NamedTextColor.AQUA)).put((Object)"chatformatter.color.red", (Object)TextColorTagResolver.of(NamedTextColor.RED)).put((Object)"chatformatter.color.light_purple", (Object)TextColorTagResolver.of(NamedTextColor.LIGHT_PURPLE)).put((Object)"chatformatter.color.yellow", (Object)TextColorTagResolver.of(NamedTextColor.YELLOW)).put((Object)"chatformatter.color.white", (Object)TextColorTagResolver.of(NamedTextColor.WHITE)).put((Object)"chatformatter.score", (Object)StandardTags.score()).put((Object)"chatformatter.selector", (Object)StandardTags.selector()).put((Object)"chatformatter.translatable", (Object)TagResolver.resolver(StandardTags.translatable(), StandardTags.translatableFallback())).put((Object)"chatformatter.font", (Object)StandardTags.font()).put((Object)"chatformatter.keybind", (Object)StandardTags.keybind()).put((Object)"chatformatter.nbt", (Object)StandardTags.nbt()).build();
    private static final GsonComponentSerializer GSON = GsonComponentSerializer.builder().editOptions(builder -> builder.values(JSONOptions.compatibility())).build();
    private static final MiniMessage EMPTY_MESSAGE_DESERIALIZER = MiniMessage.builder().postProcessor(new AdventureUrlPostProcessor()).tags(TagResolver.empty()).build();
    private final MiniMessage miniMessage;
    private final ChatSettings settings;
    private final ChatRankProvider rankProvider;
    private final PlaceholderRegistry placeholderRegistry;
    private final TemplateService templateService;

    ChatHandlerImpl(MiniMessage miniMessage, ChatSettings settings, ChatRankProvider rankProvider, PlaceholderRegistry placeholderRegistry, TemplateService templateService) {
        this.miniMessage = miniMessage;
        this.settings = settings;
        this.rankProvider = rankProvider;
        this.placeholderRegistry = placeholderRegistry;
        this.templateService = templateService;
    }

    @Override
    public ChatRenderedMessage process(ChatMessage chatMessage) {
        Player sender = chatMessage.sender();
        Optional<Player> viewer = chatMessage.viewer();
        String format = this.settings.getRawFormat(this.rankProvider.getRank(sender));
        format = this.templateService.applyTemplates(format);
        format = viewer.isEmpty() ? this.placeholderRegistry.format(format, sender) : this.placeholderRegistry.format(format, sender, viewer.get());
        format = Legacy.legacyToAdventure(format);
        Component renderedMessage = this.miniMessage.deserialize(format, this.createTags(chatMessage));
        return new ChatRenderedMessage(sender, (String)GSON.serialize(renderedMessage));
    }

    private TagResolver createTags(ChatMessage chatMessage) {
        Player sender = chatMessage.sender();
        Object message = GSON.deserialize(chatMessage.jsonMessage());
        String serialize = LegacyComponentSerializer.legacySection().serialize((Component)message);
        TagResolver.Single displayNamePlaceholder = this.displayNamePlaceholder(sender);
        TagResolver.Single namePlaceholder = this.namePlaceholder(sender);
        TagResolver.Single messagePlaceholder = this.messagePlaceholder(sender, serialize);
        return TagResolver.resolver(displayNamePlaceholder, namePlaceholder, messagePlaceholder);
    }

    private TagResolver.Single displayNamePlaceholder(Player sender) {
        return Placeholder.parsed("displayname", Legacy.legacyToAdventure(sender.getDisplayName()));
    }

    private TagResolver.Single namePlaceholder(Player sender) {
        return Placeholder.parsed("name", sender.getName());
    }

    private TagResolver.Single messagePlaceholder(Player sender, String rawMessage) {
        TagResolver permittedTags = this.providePermittedTags(sender);
        rawMessage = Legacy.legacyToAdventure(rawMessage, permission -> sender.hasPermission(permission));
        Component componentMessage = EMPTY_MESSAGE_DESERIALIZER.deserialize(rawMessage, permittedTags);
        return Placeholder.component("message", componentMessage);
    }

    private TagResolver providePermittedTags(Player player) {
        ArrayList<TagResolver> tagResolvers = new ArrayList<TagResolver>();
        if (player.hasPermission(PERMISSION_ALL)) {
            return TagResolver.standard();
        }
        for (Map.Entry<String, TagResolver> entry : TAG_RESOLVERS_BY_PERMISSION.entrySet()) {
            if (!player.hasPermission(entry.getKey())) continue;
            tagResolvers.add(entry.getValue());
        }
        return TagResolver.resolver(tagResolvers);
    }
}

