/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.formatter;

import com.eternalcode.formatter.ChatFormatterApi;
import com.eternalcode.formatter.ChatFormatterApiProvider;
import com.eternalcode.formatter.ChatFormatterCommand;
import com.eternalcode.formatter.ChatHandler;
import com.eternalcode.formatter.ChatHandlerImpl;
import com.eternalcode.formatter.config.ConfigManager;
import com.eternalcode.formatter.config.PluginConfig;
import com.eternalcode.formatter.libs.net.kyori.adventure.platform.bukkit.BukkitAudiences;
import com.eternalcode.formatter.libs.net.kyori.adventure.text.minimessage.MiniMessage;
import com.eternalcode.formatter.libs.org.bstats.bukkit.Metrics;
import com.eternalcode.formatter.placeholder.ConfiguredReplacer;
import com.eternalcode.formatter.placeholder.PlaceholderRegistry;
import com.eternalcode.formatter.placeholderapi.PlaceholderAPIInitializer;
import com.eternalcode.formatter.rank.ChatRankProvider;
import com.eternalcode.formatter.rank.VaultInitializer;
import com.eternalcode.formatter.template.TemplateService;
import com.eternalcode.formatter.updater.UpdaterController;
import com.eternalcode.formatter.updater.UpdaterService;
import com.google.common.base.Stopwatch;
import java.util.concurrent.TimeUnit;
import org.bukkit.Server;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class ChatFormatterPlugin
implements ChatFormatterApi {
    private final PlaceholderRegistry placeholderRegistry;
    private final TemplateService templateService;
    private final ChatRankProvider rankProvider;
    private final ChatHandler chatHandler;

    public ChatFormatterPlugin(Plugin plugin) {
        Server server = plugin.getServer();
        Stopwatch stopwatch = Stopwatch.createStarted();
        ConfigManager configManager = new ConfigManager(plugin.getDataFolder());
        configManager.loadAndRenderConfigs();
        PluginConfig pluginConfig = configManager.getPluginConfig();
        this.placeholderRegistry = new PlaceholderRegistry();
        PlaceholderAPIInitializer.initialize(server, this.placeholderRegistry);
        this.placeholderRegistry.addReplacer(new ConfiguredReplacer(pluginConfig));
        this.templateService = new TemplateService(pluginConfig);
        this.rankProvider = VaultInitializer.initialize(server);
        UpdaterService updaterService = new UpdaterService(plugin.getDescription());
        BukkitAudiences audienceProvider = BukkitAudiences.create(plugin);
        MiniMessage miniMessage = MiniMessage.miniMessage();
        new Metrics(plugin, 15199);
        this.chatHandler = new ChatHandlerImpl(miniMessage, pluginConfig, this.rankProvider, this.placeholderRegistry, this.templateService);
        server.getPluginCommand("chatformatter").setExecutor((CommandExecutor)new ChatFormatterCommand(configManager, audienceProvider, miniMessage));
        server.getPluginManager().registerEvents((Listener)new UpdaterController(updaterService, pluginConfig, audienceProvider, miniMessage), plugin);
        ChatFormatterApiProvider.enable(this);
        plugin.getLogger().info("Plugin enabled in " + stopwatch.elapsed(TimeUnit.MILLISECONDS) + "ms");
    }

    public void close() {
        ChatFormatterApiProvider.disable();
    }

    @Override
    public PlaceholderRegistry getPlaceholderRegistry() {
        return this.placeholderRegistry;
    }

    @Override
    public TemplateService getTemplateService() {
        return this.templateService;
    }

    @Override
    public ChatRankProvider getRankProvider() {
        return this.rankProvider;
    }

    @Override
    public ChatHandler getChatHandler() {
        return this.chatHandler;
    }
}

