/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.formatter;

import com.eternalcode.formatter.config.ConfigManager;
import com.eternalcode.formatter.libs.net.kyori.adventure.audience.Audience;
import com.eternalcode.formatter.libs.net.kyori.adventure.platform.AudienceProvider;
import com.eternalcode.formatter.libs.net.kyori.adventure.text.Component;
import com.eternalcode.formatter.libs.net.kyori.adventure.text.minimessage.MiniMessage;
import com.google.common.base.Stopwatch;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ChatFormatterCommand
implements CommandExecutor,
TabCompleter {
    private static final String RELOAD_MESSAGE = "<b><gradient:#29fbff:#38b3ff>ChatFormatter:</gradient></b> <green>Successfully reloaded configs in %sms!";
    public static final String RELOAD_PERMISSION = "chatformatter.reload";
    private final ConfigManager configManager;
    private final AudienceProvider provider;
    private final MiniMessage miniMessage;

    ChatFormatterCommand(ConfigManager configManager, AudienceProvider provider, MiniMessage miniMessage) {
        this.configManager = configManager;
        this.provider = provider;
        this.miniMessage = miniMessage;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0 || !args[0].equalsIgnoreCase("reload")) {
            sender.sendMessage(command.getUsage());
            return true;
        }
        if (sender.hasPermission(RELOAD_PERMISSION)) {
            Audience audience;
            Stopwatch stopwatch = Stopwatch.createStarted();
            this.configManager.loadAndRenderConfigs();
            long millis = stopwatch.elapsed(TimeUnit.MILLISECONDS);
            Object deserialized = this.miniMessage.deserialize(String.format(RELOAD_MESSAGE, millis));
            if (sender instanceof Player) {
                Player player = (Player)sender;
                audience = this.provider.player(player.getUniqueId());
            } else {
                audience = this.provider.console();
            }
            Audience audience2 = audience;
            audience2.sendMessage((Component)deserialized);
            return true;
        }
        return false;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length == 1 && sender.hasPermission(RELOAD_PERMISSION)) {
            return List.of("reload");
        }
        return Collections.emptyList();
    }
}

