/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.math;

public final class MathUtils {
    public static final double SAFE_MIN = Double.MIN_NORMAL;

    private MathUtils() {
    }

    public static int divisorMod(int a2, int n) {
        return (int)((double)a2 - (double)n * Math.floor(Math.floor(a2) / (double)n));
    }

    public static double dCos(double degrees) {
        int dInt = (int)degrees;
        if (degrees == (double)dInt && dInt % 90 == 0) {
            if ((dInt %= 360) < 0) {
                dInt += 360;
            }
            return switch (dInt) {
                case 0 -> 1.0;
                case 90, 270 -> 0.0;
                case 180 -> -1.0;
                default -> throw new AssertionError((Object)("dInt should be one of 0, 90, 180, 270; got " + dInt));
            };
        }
        return Math.cos(Math.toRadians(degrees));
    }

    public static double dSin(double degrees) {
        int dInt = (int)degrees;
        if (degrees == (double)dInt && dInt % 90 == 0) {
            if ((dInt %= 360) < 0) {
                dInt += 360;
            }
            return switch (dInt) {
                case 0, 180 -> 0.0;
                case 90 -> 1.0;
                case 270 -> -1.0;
                default -> throw new AssertionError((Object)("dInt should be one of 0, 90, 180, 270; got " + dInt));
            };
        }
        return Math.sin(Math.toRadians(degrees));
    }

    public static double roundHalfUp(double value) {
        return Math.signum(value) * (double)Math.round(Math.abs(value));
    }
}

