/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.internal.util;

import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.math.transform.Identity;
import com.sk89q.worldedit.math.transform.ScaleAndTranslateTransform;
import com.sk89q.worldedit.math.transform.Transform;
import com.sk89q.worldedit.regions.Region;

public final class TransformUtil {
    private TransformUtil() {
    }

    public static Transform createTransformForExpressionCommand(Actor actor, LocalSession session, Region region, boolean useRawCoords, boolean offsetPlacement, boolean offsetCenter) throws IncompleteRegionException {
        Vector3 placement = session.getPlacementPosition(actor).toVector3();
        Vector3 min = region.getMinimumPoint().toVector3();
        Vector3 max = region.getMaximumPoint().toVector3();
        return TransformUtil.createTransformForExpressionCommand(useRawCoords, offsetPlacement, offsetCenter, min, max, placement);
    }

    public static Transform createTransformForExpressionCommand(boolean useRawCoords, boolean offsetPlacement, boolean offsetCenter, Vector3 min, Vector3 max, Vector3 placement) {
        if (useRawCoords) {
            return new Identity();
        }
        if (offsetPlacement) {
            return new ScaleAndTranslateTransform(placement, Vector3.ONE);
        }
        Vector3 center = max.add(min).multiply(0.5);
        if (offsetCenter) {
            return new ScaleAndTranslateTransform(center, Vector3.ONE);
        }
        Vector3 scale = max.subtract(center);
        if (scale.x() == 0.0) {
            scale = scale.withX(1.0);
        }
        if (scale.y() == 0.0) {
            scale = scale.withY(1.0);
        }
        if (scale.z() == 0.0) {
            scale = scale.withZ(1.0);
        }
        return new ScaleAndTranslateTransform(center, scale);
    }
}

