/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit.fastutil.objects;

import com.sk89q.worldedit.bukkit.fastutil.SafeMath;
import com.sk89q.worldedit.bukkit.fastutil.objects.AbstractObjectSet;
import com.sk89q.worldedit.bukkit.fastutil.objects.ObjectArrays;
import com.sk89q.worldedit.bukkit.fastutil.objects.ObjectCollection;
import com.sk89q.worldedit.bukkit.fastutil.objects.ObjectIterator;
import com.sk89q.worldedit.bukkit.fastutil.objects.ObjectOpenHashSet;
import com.sk89q.worldedit.bukkit.fastutil.objects.ObjectSet;
import com.sk89q.worldedit.bukkit.fastutil.objects.ObjectSpliterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;

public class ObjectArraySet<K>
extends AbstractObjectSet<K>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    protected transient Object[] a;
    protected int size;

    public ObjectArraySet(Object[] a2) {
        this.a = a2;
        this.size = a2.length;
    }

    public ObjectArraySet() {
        this.a = ObjectArrays.EMPTY_ARRAY;
    }

    public ObjectArraySet(int capacity) {
        this.a = new Object[capacity];
    }

    public ObjectArraySet(ObjectCollection<K> c2) {
        this(c2.size());
        this.addAll(c2);
    }

    public ObjectArraySet(Collection<? extends K> c2) {
        this(c2.size());
        this.addAll(c2);
    }

    public ObjectArraySet(ObjectSet<K> c2) {
        this(c2.size());
        int i = 0;
        for (Object x : c2) {
            this.a[i] = x;
            ++i;
        }
        this.size = i;
    }

    public ObjectArraySet(Set<? extends K> c2) {
        this(c2.size());
        int i = 0;
        for (K x : c2) {
            this.a[i] = x;
            ++i;
        }
        this.size = i;
    }

    public ObjectArraySet(Object[] a2, int size) {
        this.a = a2;
        this.size = size;
        if (size > a2.length) {
            throw new IllegalArgumentException("The provided size (" + size + ") is larger than or equal to the array size (" + a2.length + ")");
        }
    }

    public static <K> ObjectArraySet<K> of() {
        return ObjectArraySet.ofUnchecked();
    }

    public static <K> ObjectArraySet<K> of(K e) {
        return ObjectArraySet.ofUnchecked(e);
    }

    @SafeVarargs
    public static <K> ObjectArraySet<K> of(K ... a2) {
        if (a2.length == 2) {
            if (Objects.equals(a2[0], a2[1])) {
                throw new IllegalArgumentException("Duplicate element: " + a2[1]);
            }
        } else if (a2.length > 2) {
            ObjectOpenHashSet.of(a2);
        }
        return ObjectArraySet.ofUnchecked(a2);
    }

    public static <K> ObjectArraySet<K> ofUnchecked() {
        return new ObjectArraySet<K>();
    }

    @SafeVarargs
    public static <K> ObjectArraySet<K> ofUnchecked(K ... a2) {
        return new ObjectArraySet<K>(a2);
    }

    private int findKey(Object o) {
        Object[] a2 = this.a;
        int i = this.size;
        while (i-- != 0) {
            if (!Objects.equals(a2[i], o)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ObjectIterator<K> iterator() {
        return new ObjectIterator<K>(){
            int curr = -1;
            int next = 0;

            @Override
            public boolean hasNext() {
                return this.next < ObjectArraySet.this.size;
            }

            @Override
            public K next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.curr = this.next++;
                return ObjectArraySet.this.a[this.curr];
            }

            @Override
            public void remove() {
                if (this.curr == -1) {
                    throw new IllegalStateException();
                }
                this.curr = -1;
                int tail = ObjectArraySet.this.size-- - this.next--;
                System.arraycopy(ObjectArraySet.this.a, this.next + 1, ObjectArraySet.this.a, this.next, tail);
                ObjectArraySet.this.a[ObjectArraySet.this.size] = null;
            }

            @Override
            public int skip(int n) {
                if (n < 0) {
                    throw new IllegalArgumentException("Argument must be nonnegative: " + n);
                }
                n = Math.min(n, ObjectArraySet.this.size - this.next);
                this.next += n;
                if (n != 0) {
                    this.curr = this.next - 1;
                }
                return n;
            }

            @Override
            public void forEachRemaining(Consumer<? super K> action) {
                Object[] a2 = ObjectArraySet.this.a;
                while (this.next < ObjectArraySet.this.size) {
                    action.accept(a2[this.next++]);
                }
            }
        };
    }

    @Override
    public ObjectSpliterator<K> spliterator() {
        return new Spliterator();
    }

    @Override
    public boolean contains(Object k) {
        return this.findKey(k) != -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean remove(Object k) {
        int pos = this.findKey(k);
        if (pos == -1) {
            return false;
        }
        int tail = this.size - pos - 1;
        for (int i = 0; i < tail; ++i) {
            this.a[pos + i] = this.a[pos + i + 1];
        }
        --this.size;
        this.a[this.size] = null;
        return true;
    }

    @Override
    public boolean add(K k) {
        int pos = this.findKey(k);
        if (pos != -1) {
            return false;
        }
        if (this.size == this.a.length) {
            Object[] b2 = new Object[this.size == 0 ? 2 : this.size * 2];
            int i = this.size;
            while (i-- != 0) {
                b2[i] = this.a[i];
            }
            this.a = b2;
        }
        this.a[this.size++] = k;
        return true;
    }

    @Override
    public void clear() {
        Arrays.fill(this.a, 0, this.size, null);
        this.size = 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Object[] toArray() {
        int size = this.size();
        if (size == 0) {
            return ObjectArrays.EMPTY_ARRAY;
        }
        return Arrays.copyOf(this.a, size, Object[].class);
    }

    @Override
    public <T> T[] toArray(T[] a2) {
        if (a2 == null) {
            a2 = new Object[this.size];
        } else if (a2.length < this.size) {
            a2 = (Object[])Array.newInstance(a2.getClass().getComponentType(), this.size);
        }
        System.arraycopy(this.a, 0, a2, 0, this.size);
        if (a2.length > this.size) {
            a2[this.size] = null;
        }
        return a2;
    }

    public ObjectArraySet<K> clone() {
        ObjectArraySet c2;
        try {
            c2 = (ObjectArraySet)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c2.a = (Object[])this.a.clone();
        return c2;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Object[] a2 = this.a;
        for (int i = 0; i < this.size; ++i) {
            s.writeObject(a2[i]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.a = new Object[this.size];
        Object[] a2 = this.a;
        for (int i = 0; i < this.size; ++i) {
            a2[i] = s.readObject();
        }
    }

    private final class Spliterator
    implements ObjectSpliterator<K> {
        boolean hasSplit = false;
        int pos;
        int max;

        public Spliterator() {
            this(0, objectArraySet.size, false);
        }

        private Spliterator(int pos, int max, boolean hasSplit) {
            assert (pos <= max) : "pos " + pos + " must be <= max " + max;
            this.pos = pos;
            this.max = max;
            this.hasSplit = hasSplit;
        }

        private int getWorkingMax() {
            return this.hasSplit ? this.max : ObjectArraySet.this.size;
        }

        @Override
        public int characteristics() {
            return 16465;
        }

        @Override
        public long estimateSize() {
            return this.getWorkingMax() - this.pos;
        }

        @Override
        public boolean tryAdvance(Consumer<? super K> action) {
            if (this.pos >= this.getWorkingMax()) {
                return false;
            }
            action.accept(ObjectArraySet.this.a[this.pos++]);
            return true;
        }

        @Override
        public void forEachRemaining(Consumer<? super K> action) {
            Object[] a2 = ObjectArraySet.this.a;
            int max = this.getWorkingMax();
            while (this.pos < max) {
                action.accept(a2[this.pos]);
                ++this.pos;
            }
        }

        @Override
        public long skip(long n) {
            if (n < 0L) {
                throw new IllegalArgumentException("Argument must be nonnegative: " + n);
            }
            int max = this.getWorkingMax();
            if (this.pos >= max) {
                return 0L;
            }
            int remaining = max - this.pos;
            if (n < (long)remaining) {
                this.pos = SafeMath.safeLongToInt((long)this.pos + n);
                return n;
            }
            n = remaining;
            this.pos = max;
            return n;
        }

        @Override
        public ObjectSpliterator<K> trySplit() {
            int myNewPos;
            int max = this.getWorkingMax();
            int retLen = max - this.pos >> 1;
            if (retLen <= 1) {
                return null;
            }
            this.max = max;
            int retMax = myNewPos = this.pos + retLen;
            int oldPos = this.pos;
            this.pos = myNewPos;
            this.hasSplit = true;
            return new Spliterator(oldPos, retMax, true);
        }
    }
}

