/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit.fastutil.longs;

import com.sk89q.worldedit.bukkit.fastutil.longs.LongArrays;
import com.sk89q.worldedit.bukkit.fastutil.longs.LongCollection;
import com.sk89q.worldedit.bukkit.fastutil.longs.LongConsumer;
import com.sk89q.worldedit.bukkit.fastutil.longs.LongIterator;
import com.sk89q.worldedit.bukkit.fastutil.longs.LongIterators;
import com.sk89q.worldedit.bukkit.fastutil.longs.LongPredicate;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;

public abstract class AbstractLongCollection
extends AbstractCollection<Long>
implements LongCollection {
    protected AbstractLongCollection() {
    }

    @Override
    public abstract LongIterator iterator();

    @Override
    public boolean add(long k) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(long k) {
        LongIterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (k != iterator.nextLong()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean rem(long k) {
        LongIterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (k != iterator.nextLong()) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public boolean add(Long key) {
        return LongCollection.super.add(key);
    }

    @Override
    @Deprecated
    public boolean contains(Object key) {
        return LongCollection.super.contains(key);
    }

    @Override
    @Deprecated
    public boolean remove(Object key) {
        return LongCollection.super.remove(key);
    }

    @Override
    public long[] toArray(long[] a2) {
        int size = this.size();
        if (a2 == null) {
            a2 = new long[size];
        } else if (a2.length < size) {
            a2 = Arrays.copyOf(a2, size);
        }
        LongIterators.unwrap(this.iterator(), a2);
        return a2;
    }

    @Override
    public long[] toLongArray() {
        int size = this.size();
        if (size == 0) {
            return LongArrays.EMPTY_ARRAY;
        }
        long[] a2 = new long[size];
        LongIterators.unwrap(this.iterator(), a2);
        return a2;
    }

    @Override
    @Deprecated
    public long[] toLongArray(long[] a2) {
        return this.toArray(a2);
    }

    @Override
    public final void forEach(LongConsumer action) {
        LongCollection.super.forEach(action);
    }

    @Override
    public final boolean removeIf(LongPredicate filter) {
        return LongCollection.super.removeIf(filter);
    }

    @Override
    public boolean addAll(LongCollection c2) {
        boolean retVal = false;
        LongIterator i = c2.iterator();
        while (i.hasNext()) {
            if (!this.add(i.nextLong())) continue;
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean addAll(Collection<? extends Long> c2) {
        if (c2 instanceof LongCollection) {
            return this.addAll((LongCollection)c2);
        }
        return super.addAll(c2);
    }

    @Override
    public boolean containsAll(LongCollection c2) {
        LongIterator i = c2.iterator();
        while (i.hasNext()) {
            if (this.contains(i.nextLong())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> c2) {
        if (c2 instanceof LongCollection) {
            return this.containsAll((LongCollection)c2);
        }
        return super.containsAll(c2);
    }

    @Override
    public boolean removeAll(LongCollection c2) {
        boolean retVal = false;
        LongIterator i = c2.iterator();
        while (i.hasNext()) {
            if (!this.rem(i.nextLong())) continue;
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean removeAll(Collection<?> c2) {
        if (c2 instanceof LongCollection) {
            return this.removeAll((LongCollection)c2);
        }
        return super.removeAll(c2);
    }

    @Override
    public boolean retainAll(LongCollection c2) {
        boolean retVal = false;
        LongIterator i = this.iterator();
        while (i.hasNext()) {
            if (c2.contains(i.nextLong())) continue;
            i.remove();
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean retainAll(Collection<?> c2) {
        if (c2 instanceof LongCollection) {
            return this.retainAll((LongCollection)c2);
        }
        return super.retainAll(c2);
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        LongIterator i = this.iterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            long k = i.nextLong();
            s.append(String.valueOf(k));
        }
        s.append("}");
        return s.toString();
    }
}

