/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit.fastutil.doubles;

import com.sk89q.worldedit.bukkit.fastutil.Hash;
import com.sk89q.worldedit.bukkit.fastutil.HashCommon;
import com.sk89q.worldedit.bukkit.fastutil.doubles.AbstractDoubleSet;
import com.sk89q.worldedit.bukkit.fastutil.doubles.DoubleArrayList;
import com.sk89q.worldedit.bukkit.fastutil.doubles.DoubleArrays;
import com.sk89q.worldedit.bukkit.fastutil.doubles.DoubleCollection;
import com.sk89q.worldedit.bukkit.fastutil.doubles.DoubleCollections;
import com.sk89q.worldedit.bukkit.fastutil.doubles.DoubleIterator;
import com.sk89q.worldedit.bukkit.fastutil.doubles.DoubleIterators;
import com.sk89q.worldedit.bukkit.fastutil.doubles.DoubleSpliterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.DoubleConsumer;
import java.util.stream.DoubleStream;

public class DoubleOpenHashSet
extends AbstractDoubleSet
implements Serializable,
Cloneable,
Hash {
    private static final long serialVersionUID = 0L;
    private static final boolean ASSERTS = false;
    protected transient double[] key;
    protected transient int mask;
    protected transient boolean containsNull;
    protected transient int n;
    protected transient int maxFill;
    protected final transient int minN;
    protected int size;
    protected final float f;

    public DoubleOpenHashSet(int expected, float f) {
        if (f <= 0.0f || f >= 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.minN = this.n = HashCommon.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, f);
        this.key = new double[this.n + 1];
    }

    public DoubleOpenHashSet(int expected) {
        this(expected, 0.75f);
    }

    public DoubleOpenHashSet() {
        this(16, 0.75f);
    }

    public DoubleOpenHashSet(Collection<? extends Double> c2, float f) {
        this(c2.size(), f);
        this.addAll(c2);
    }

    public DoubleOpenHashSet(Collection<? extends Double> c2) {
        this(c2, 0.75f);
    }

    public DoubleOpenHashSet(DoubleCollection c2, float f) {
        this(c2.size(), f);
        this.addAll(c2);
    }

    public DoubleOpenHashSet(DoubleCollection c2) {
        this(c2, 0.75f);
    }

    public DoubleOpenHashSet(DoubleIterator i, float f) {
        this(16, f);
        while (i.hasNext()) {
            this.add(i.nextDouble());
        }
    }

    public DoubleOpenHashSet(DoubleIterator i) {
        this(i, 0.75f);
    }

    public DoubleOpenHashSet(Iterator<?> i, float f) {
        this(DoubleIterators.asDoubleIterator(i), f);
    }

    public DoubleOpenHashSet(Iterator<?> i) {
        this(DoubleIterators.asDoubleIterator(i));
    }

    public DoubleOpenHashSet(double[] a2, int offset, int length, float f) {
        this(length < 0 ? 0 : length, f);
        DoubleArrays.ensureOffsetLength(a2, offset, length);
        for (int i = 0; i < length; ++i) {
            this.add(a2[offset + i]);
        }
    }

    public DoubleOpenHashSet(double[] a2, int offset, int length) {
        this(a2, offset, length, 0.75f);
    }

    public DoubleOpenHashSet(double[] a2, float f) {
        this(a2, 0, a2.length, f);
    }

    public DoubleOpenHashSet(double[] a2) {
        this(a2, 0.75f);
    }

    public static DoubleOpenHashSet of() {
        return new DoubleOpenHashSet();
    }

    public static DoubleOpenHashSet of(double e) {
        DoubleOpenHashSet result = new DoubleOpenHashSet(1, 0.75f);
        result.add(e);
        return result;
    }

    public static DoubleOpenHashSet of(double e0, double e1) {
        DoubleOpenHashSet result = new DoubleOpenHashSet(2, 0.75f);
        result.add(e0);
        if (!result.add(e1)) {
            throw new IllegalArgumentException("Duplicate element: " + e1);
        }
        return result;
    }

    public static DoubleOpenHashSet of(double e0, double e1, double e2) {
        DoubleOpenHashSet result = new DoubleOpenHashSet(3, 0.75f);
        result.add(e0);
        if (!result.add(e1)) {
            throw new IllegalArgumentException("Duplicate element: " + e1);
        }
        if (!result.add(e2)) {
            throw new IllegalArgumentException("Duplicate element: " + e2);
        }
        return result;
    }

    public static DoubleOpenHashSet of(double ... a2) {
        DoubleOpenHashSet result = new DoubleOpenHashSet(a2.length, 0.75f);
        for (double element : a2) {
            if (result.add(element)) continue;
            throw new IllegalArgumentException("Duplicate element " + element);
        }
        return result;
    }

    public static DoubleOpenHashSet toSet(DoubleStream stream) {
        return stream.collect(DoubleOpenHashSet::new, DoubleOpenHashSet::add, DoubleOpenHashSet::addAll);
    }

    public static DoubleOpenHashSet toSetWithExpectedSize(DoubleStream stream, int expectedSize) {
        if (expectedSize <= 16) {
            return DoubleOpenHashSet.toSet(stream);
        }
        return stream.collect(new DoubleCollections.SizeDecreasingSupplier<DoubleOpenHashSet>(expectedSize, size -> size <= 16 ? new DoubleOpenHashSet() : new DoubleOpenHashSet(size)), DoubleOpenHashSet::add, DoubleOpenHashSet::addAll);
    }

    private int realSize() {
        return this.containsNull ? this.size - 1 : this.size;
    }

    public void ensureCapacity(int capacity) {
        int needed = HashCommon.arraySize(capacity, this.f);
        if (needed > this.n) {
            this.rehash(needed);
        }
    }

    private void tryCapacity(long capacity) {
        int needed = (int)Math.min(0x40000000L, Math.max(2L, HashCommon.nextPowerOfTwo((long)Math.ceil((float)capacity / this.f))));
        if (needed > this.n) {
            this.rehash(needed);
        }
    }

    @Override
    public boolean addAll(DoubleCollection c2) {
        if ((double)this.f <= 0.5) {
            this.ensureCapacity(c2.size());
        } else {
            this.tryCapacity(this.size() + c2.size());
        }
        return super.addAll(c2);
    }

    @Override
    public boolean addAll(Collection<? extends Double> c2) {
        if ((double)this.f <= 0.5) {
            this.ensureCapacity(c2.size());
        } else {
            this.tryCapacity(this.size() + c2.size());
        }
        return super.addAll(c2);
    }

    @Override
    public boolean add(double k) {
        if (Double.doubleToRawLongBits(k) == 0L) {
            if (this.containsNull) {
                return false;
            }
            this.containsNull = true;
        } else {
            double[] key = this.key;
            int pos = (int)HashCommon.mix(Double.doubleToRawLongBits(k)) & this.mask;
            double curr = key[pos];
            if (Double.doubleToRawLongBits(curr) != 0L) {
                if (Double.doubleToRawLongBits(curr) == Double.doubleToRawLongBits(k)) {
                    return false;
                }
                while (Double.doubleToRawLongBits(curr = key[pos = pos + 1 & this.mask]) != 0L) {
                    if (Double.doubleToRawLongBits(curr) != Double.doubleToRawLongBits(k)) continue;
                    return false;
                }
            }
            key[pos] = k;
        }
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return true;
    }

    protected final void shiftKeys(int pos) {
        double[] key = this.key;
        while (true) {
            double curr;
            int last = pos;
            pos = last + 1 & this.mask;
            while (true) {
                if (Double.doubleToRawLongBits(curr = key[pos]) == 0L) {
                    key[last] = 0.0;
                    return;
                }
                int slot = (int)HashCommon.mix(Double.doubleToRawLongBits(curr)) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & this.mask;
            }
            key[last] = curr;
        }
    }

    private boolean removeEntry(int pos) {
        --this.size;
        this.shiftKeys(pos);
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return true;
    }

    private boolean removeNullEntry() {
        this.containsNull = false;
        this.key[this.n] = 0.0;
        --this.size;
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return true;
    }

    @Override
    public boolean remove(double k) {
        if (Double.doubleToRawLongBits(k) == 0L) {
            if (this.containsNull) {
                return this.removeNullEntry();
            }
            return false;
        }
        double[] key = this.key;
        int pos = (int)HashCommon.mix(Double.doubleToRawLongBits(k)) & this.mask;
        double curr = key[pos];
        if (Double.doubleToRawLongBits(curr) == 0L) {
            return false;
        }
        if (Double.doubleToRawLongBits(k) == Double.doubleToRawLongBits(curr)) {
            return this.removeEntry(pos);
        }
        do {
            if (Double.doubleToRawLongBits(curr = key[pos = pos + 1 & this.mask]) != 0L) continue;
            return false;
        } while (Double.doubleToRawLongBits(k) != Double.doubleToRawLongBits(curr));
        return this.removeEntry(pos);
    }

    @Override
    public boolean contains(double k) {
        if (Double.doubleToRawLongBits(k) == 0L) {
            return this.containsNull;
        }
        double[] key = this.key;
        int pos = (int)HashCommon.mix(Double.doubleToRawLongBits(k)) & this.mask;
        double curr = key[pos];
        if (Double.doubleToRawLongBits(curr) == 0L) {
            return false;
        }
        if (Double.doubleToRawLongBits(k) == Double.doubleToRawLongBits(curr)) {
            return true;
        }
        do {
            if (Double.doubleToRawLongBits(curr = key[pos = pos + 1 & this.mask]) != 0L) continue;
            return false;
        } while (Double.doubleToRawLongBits(k) != Double.doubleToRawLongBits(curr));
        return true;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        this.containsNull = false;
        Arrays.fill(this.key, 0.0);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public DoubleIterator iterator() {
        return new SetIterator();
    }

    @Override
    public DoubleSpliterator spliterator() {
        return new SetSpliterator();
    }

    @Override
    public void forEach(DoubleConsumer action) {
        double[] key = this.key;
        if (this.containsNull) {
            action.accept(key[this.n]);
        }
        int pos = this.n;
        while (pos-- != 0) {
            if (Double.doubleToRawLongBits(key[pos]) == 0L) continue;
            action.accept(key[pos]);
        }
    }

    public boolean trim() {
        return this.trim(this.size);
    }

    public boolean trim(int n) {
        int l = HashCommon.nextPowerOfTwo((int)Math.ceil((float)n / this.f));
        if (l >= this.n || this.size > HashCommon.maxFill(l, this.f)) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newN) {
        double[] key = this.key;
        int mask = newN - 1;
        double[] newKey = new double[newN + 1];
        int i = this.n;
        int j = this.realSize();
        while (j-- != 0) {
            while (Double.doubleToRawLongBits(key[--i]) == 0L) {
            }
            int pos = (int)HashCommon.mix(Double.doubleToRawLongBits(key[i])) & mask;
            if (Double.doubleToRawLongBits(newKey[pos]) != 0L) {
                while (Double.doubleToRawLongBits(newKey[pos = pos + 1 & mask]) != 0L) {
                }
            }
            newKey[pos] = key[i];
        }
        this.n = newN;
        this.mask = mask;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = newKey;
    }

    public DoubleOpenHashSet clone() {
        DoubleOpenHashSet c2;
        try {
            c2 = (DoubleOpenHashSet)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c2.key = (double[])this.key.clone();
        c2.containsNull = this.containsNull;
        return c2;
    }

    @Override
    public int hashCode() {
        int h = 0;
        double[] key = this.key;
        int j = this.realSize();
        int i = 0;
        while (j-- != 0) {
            while (Double.doubleToRawLongBits(key[i]) == 0L) {
                ++i;
            }
            h += HashCommon.double2int(key[i]);
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        DoubleIterator i = this.iterator();
        s.defaultWriteObject();
        int j = this.size;
        while (j-- != 0) {
            s.writeDouble(i.nextDouble());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.n = HashCommon.arraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new double[this.n + 1];
        double[] key = this.key;
        int i = this.size;
        while (i-- != 0) {
            int pos;
            double k = s.readDouble();
            if (Double.doubleToRawLongBits(k) == 0L) {
                pos = this.n;
                this.containsNull = true;
            } else {
                pos = (int)HashCommon.mix(Double.doubleToRawLongBits(k)) & this.mask;
                if (Double.doubleToRawLongBits(key[pos]) != 0L) {
                    while (Double.doubleToRawLongBits(key[pos = pos + 1 & this.mask]) != 0L) {
                    }
                }
            }
            key[pos] = k;
        }
    }

    private void checkTable() {
    }

    private final class SetIterator
    implements DoubleIterator {
        int pos;
        int last;
        int c;
        boolean mustReturnNull;
        DoubleArrayList wrapped;

        private SetIterator() {
            this.pos = DoubleOpenHashSet.this.n;
            this.last = -1;
            this.c = DoubleOpenHashSet.this.size;
            this.mustReturnNull = DoubleOpenHashSet.this.containsNull;
        }

        @Override
        public boolean hasNext() {
            return this.c != 0;
        }

        @Override
        public double nextDouble() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            --this.c;
            double[] key = DoubleOpenHashSet.this.key;
            if (this.mustReturnNull) {
                this.mustReturnNull = false;
                this.last = DoubleOpenHashSet.this.n;
                return key[DoubleOpenHashSet.this.n];
            }
            do {
                if (--this.pos >= 0) continue;
                this.last = Integer.MIN_VALUE;
                return this.wrapped.getDouble(-this.pos - 1);
            } while (Double.doubleToRawLongBits(key[this.pos]) == 0L);
            this.last = this.pos;
            return key[this.last];
        }

        private final void shiftKeys(int pos) {
            double[] key = DoubleOpenHashSet.this.key;
            while (true) {
                double curr;
                int last = pos;
                pos = last + 1 & DoubleOpenHashSet.this.mask;
                while (true) {
                    if (Double.doubleToRawLongBits(curr = key[pos]) == 0L) {
                        key[last] = 0.0;
                        return;
                    }
                    int slot = (int)HashCommon.mix(Double.doubleToRawLongBits(curr)) & DoubleOpenHashSet.this.mask;
                    if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                    pos = pos + 1 & DoubleOpenHashSet.this.mask;
                }
                if (pos < last) {
                    if (this.wrapped == null) {
                        this.wrapped = new DoubleArrayList(2);
                    }
                    this.wrapped.add(key[pos]);
                }
                key[last] = curr;
            }
        }

        @Override
        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            if (this.last == DoubleOpenHashSet.this.n) {
                DoubleOpenHashSet.this.containsNull = false;
                DoubleOpenHashSet.this.key[DoubleOpenHashSet.this.n] = 0.0;
            } else if (this.pos >= 0) {
                this.shiftKeys(this.last);
            } else {
                DoubleOpenHashSet.this.remove(this.wrapped.getDouble(-this.pos - 1));
                this.last = -1;
                return;
            }
            --DoubleOpenHashSet.this.size;
            this.last = -1;
        }

        @Override
        public void forEachRemaining(DoubleConsumer action) {
            double[] key = DoubleOpenHashSet.this.key;
            if (this.mustReturnNull) {
                this.mustReturnNull = false;
                this.last = DoubleOpenHashSet.this.n;
                action.accept(key[DoubleOpenHashSet.this.n]);
                --this.c;
            }
            while (this.c != 0) {
                if (--this.pos < 0) {
                    this.last = Integer.MIN_VALUE;
                    action.accept(this.wrapped.getDouble(-this.pos - 1));
                    --this.c;
                    continue;
                }
                if (Double.doubleToRawLongBits(key[this.pos]) == 0L) continue;
                this.last = this.pos;
                action.accept(key[this.last]);
                --this.c;
            }
        }
    }

    private final class SetSpliterator
    implements DoubleSpliterator {
        private static final int POST_SPLIT_CHARACTERISTICS = 257;
        int pos = 0;
        int max;
        int c;
        boolean mustReturnNull;
        boolean hasSplit;

        SetSpliterator() {
            this.max = DoubleOpenHashSet.this.n;
            this.c = 0;
            this.mustReturnNull = DoubleOpenHashSet.this.containsNull;
            this.hasSplit = false;
        }

        SetSpliterator(int pos, int max, boolean mustReturnNull, boolean hasSplit) {
            this.max = DoubleOpenHashSet.this.n;
            this.c = 0;
            this.mustReturnNull = DoubleOpenHashSet.this.containsNull;
            this.hasSplit = false;
            this.pos = pos;
            this.max = max;
            this.mustReturnNull = mustReturnNull;
            this.hasSplit = hasSplit;
        }

        @Override
        public boolean tryAdvance(DoubleConsumer action) {
            if (this.mustReturnNull) {
                this.mustReturnNull = false;
                ++this.c;
                action.accept(DoubleOpenHashSet.this.key[DoubleOpenHashSet.this.n]);
                return true;
            }
            double[] key = DoubleOpenHashSet.this.key;
            while (this.pos < this.max) {
                if (Double.doubleToRawLongBits(key[this.pos]) != 0L) {
                    ++this.c;
                    action.accept(key[this.pos++]);
                    return true;
                }
                ++this.pos;
            }
            return false;
        }

        @Override
        public void forEachRemaining(DoubleConsumer action) {
            double[] key = DoubleOpenHashSet.this.key;
            if (this.mustReturnNull) {
                this.mustReturnNull = false;
                action.accept(key[DoubleOpenHashSet.this.n]);
                ++this.c;
            }
            while (this.pos < this.max) {
                if (Double.doubleToRawLongBits(key[this.pos]) != 0L) {
                    action.accept(key[this.pos]);
                    ++this.c;
                }
                ++this.pos;
            }
        }

        @Override
        public int characteristics() {
            return this.hasSplit ? 257 : 321;
        }

        @Override
        public long estimateSize() {
            if (!this.hasSplit) {
                return DoubleOpenHashSet.this.size - this.c;
            }
            return Math.min((long)(DoubleOpenHashSet.this.size - this.c), (long)((double)DoubleOpenHashSet.this.realSize() / (double)DoubleOpenHashSet.this.n * (double)(this.max - this.pos)) + (long)(this.mustReturnNull ? 1 : 0));
        }

        @Override
        public SetSpliterator trySplit() {
            if (this.pos >= this.max - 1) {
                return null;
            }
            int retLen = this.max - this.pos >> 1;
            if (retLen <= 1) {
                return null;
            }
            int myNewPos = this.pos + retLen;
            int retPos = this.pos;
            int retMax = myNewPos;
            SetSpliterator split = new SetSpliterator(retPos, retMax, this.mustReturnNull, true);
            this.pos = myNewPos;
            this.mustReturnNull = false;
            this.hasSplit = true;
            return split;
        }

        @Override
        public long skip(long n) {
            if (n < 0L) {
                throw new IllegalArgumentException("Argument must be nonnegative: " + n);
            }
            if (n == 0L) {
                return 0L;
            }
            long skipped = 0L;
            if (this.mustReturnNull) {
                this.mustReturnNull = false;
                ++skipped;
                --n;
            }
            double[] key = DoubleOpenHashSet.this.key;
            while (this.pos < this.max && n > 0L) {
                if (Double.doubleToRawLongBits(key[this.pos++]) == 0L) continue;
                ++skipped;
                --n;
            }
            return skipped;
        }
    }
}

