/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit.adapter.impl.v1_21_11;

import com.sk89q.worldedit.world.registry.BlockMaterial;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Clearable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PaperweightBlockMaterial
implements BlockMaterial {
    private final BlockState block;

    public PaperweightBlockMaterial(BlockState block) {
        this.block = block;
    }

    @Override
    public boolean isAir() {
        return this.block.isAir();
    }

    @Override
    public boolean isFullCube() {
        return Block.isShapeFullBlock((VoxelShape)this.block.getShape((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.ZERO));
    }

    @Override
    public boolean isOpaque() {
        return this.block.canOcclude();
    }

    @Override
    public boolean isPowerSource() {
        return this.block.isSignalSource();
    }

    @Override
    public boolean isLiquid() {
        return this.block.liquid();
    }

    @Override
    public boolean isSolid() {
        return this.block.isSolid();
    }

    @Override
    public float getHardness() {
        return this.block.getDestroySpeed((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.ZERO);
    }

    @Override
    public float getResistance() {
        return this.block.getBlock().getExplosionResistance();
    }

    @Override
    public float getSlipperiness() {
        return this.block.getBlock().getFriction();
    }

    @Override
    public int getLightValue() {
        return this.block.getLightEmission();
    }

    @Override
    public boolean isFragileWhenPushed() {
        return this.block.getPistonPushReaction() == PushReaction.DESTROY;
    }

    @Override
    public boolean isUnpushable() {
        return this.block.getPistonPushReaction() == PushReaction.BLOCK;
    }

    @Override
    public boolean isTicksRandomly() {
        return this.block.isRandomlyTicking();
    }

    @Override
    public boolean isMovementBlocker() {
        return this.block.blocksMotion();
    }

    @Override
    public boolean isBurnable() {
        return this.block.ignitedByLava();
    }

    @Override
    public boolean isToolRequired() {
        return this.block.requiresCorrectToolForDrops();
    }

    @Override
    public boolean isReplacedDuringPlacement() {
        return this.block.canBeReplaced();
    }

    @Override
    public boolean isTranslucent() {
        return !this.block.canOcclude();
    }

    @Override
    public boolean hasContainer() {
        EntityBlock entityBlock;
        Block block = this.block.getBlock();
        return block instanceof EntityBlock && (entityBlock = (EntityBlock)block).newBlockEntity(BlockPos.ZERO, this.block) instanceof Clearable;
    }
}

