/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.linbus.format.snbt.impl;

public final class Elusion {
    public static boolean isSafeCharacter(char c2) {
        return 'A' <= c2 && c2 <= 'Z' || 'a' <= c2 && c2 <= 'z' || '0' <= c2 && c2 <= '9' || c2 == '_' || c2 == '.' || c2 == '+' || c2 == '-';
    }

    public static CharSequence escapeIfNeeded(String s) {
        boolean totallySafe = true;
        int singleCharCount = 0;
        int doubleCharCount = 0;
        int backslashCount = 0;
        block5: for (int i = 0; i < s.length(); ++i) {
            char c2 = s.charAt(i);
            if (totallySafe && Elusion.isSafeCharacter(c2)) continue;
            totallySafe = false;
            switch (c2) {
                case '\'': {
                    ++singleCharCount;
                    continue block5;
                }
                case '\"': {
                    ++doubleCharCount;
                    continue block5;
                }
                case '\\': {
                    ++backslashCount;
                }
            }
        }
        if (totallySafe) {
            return s;
        }
        int leastCharCount = Math.min(singleCharCount, doubleCharCount);
        StringBuilder builder = new StringBuilder(s.length() + backslashCount + leastCharCount + 2);
        char quoteChar = leastCharCount == singleCharCount ? (char)'\'' : '\"';
        builder.append(quoteChar);
        for (int i = 0; i < s.length(); ++i) {
            char c3 = s.charAt(i);
            if (c3 == '\\' || c3 == quoteChar) {
                builder.append('\\');
            }
            builder.append(c3);
        }
        builder.append(quoteChar);
        return builder;
    }

    private Elusion() {
    }
}

