/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.world.block;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import com.sk89q.worldedit.bukkit.fastutil.objects.Object2ObjectArrayMap;
import com.sk89q.worldedit.bukkit.fastutil.objects.Object2ObjectMaps;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypeStateList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

final class DefaultBlockTypeStateList
extends BlockTypeStateList {
    private final ImmutableList<PropertyEntry> propertyEntries;
    private final ImmutableList<BlockState> states;

    DefaultBlockTypeStateList(BlockType blockType) {
        List<Property<?>> properties = blockType.getProperties();
        ImmutableList.Builder propertyEntriesBuilder = ImmutableList.builderWithExpectedSize((int)properties.size());
        int nextStride = 1;
        for (Property property : properties) {
            propertyEntriesBuilder.add((Object)new PropertyEntry(property, ImmutableList.copyOf(property.values()), nextStride));
            nextStride = Math.multiplyExact(nextStride, property.values().size());
        }
        this.propertyEntries = propertyEntriesBuilder.build();
        this.states = this.createStates(nextStride, blockType);
    }

    private ImmutableList<BlockState> createStates(int totalStates, BlockType blockType) {
        int[] propertyValueCounts = new int[this.propertyEntries.size()];
        Object[] propsArray = new Property[this.propertyEntries.size()];
        for (int i = 0; i < propsArray.length; ++i) {
            propsArray[i] = ((PropertyEntry)this.propertyEntries.get((int)i)).property;
        }
        Object[] valuesArray = new Object[this.propertyEntries.size()];
        for (int i = 0; i < valuesArray.length; ++i) {
            valuesArray[i] = ((PropertyEntry)this.propertyEntries.get((int)i)).values.getFirst();
        }
        ImmutableList.Builder statesBuilder = ImmutableList.builderWithExpectedSize((int)totalStates);
        for (int i = 0; i < totalStates; ++i) {
            statesBuilder.add((Object)new BlockState(blockType, Object2ObjectMaps.unmodifiable(new Object2ObjectArrayMap(propsArray, (Object[])valuesArray.clone())), i));
            if (i + 1 >= totalStates) break;
            this.prepareNextValueInSlot(propertyValueCounts, valuesArray, 0);
        }
        return statesBuilder.build();
    }

    private void prepareNextValueInSlot(int[] propertyValueCounts, Object[] valuesArray, int index) {
        PropertyEntry entry = (PropertyEntry)this.propertyEntries.get(index);
        int n = index;
        propertyValueCounts[n] = propertyValueCounts[n] + 1;
        if (propertyValueCounts[index] >= entry.values.size()) {
            propertyValueCounts[index] = 0;
            valuesArray[index] = entry.values.getFirst();
            Verify.verify((index + 1 < propertyValueCounts.length ? 1 : 0) != 0, (String)"Tried to increment past last property", (Object[])new Object[0]);
            this.prepareNextValueInSlot(propertyValueCounts, valuesArray, index + 1);
        } else {
            valuesArray[index] = entry.values.get(propertyValueCounts[index]);
        }
    }

    @Override
    public int size() {
        return this.states.size();
    }

    @Override
    public BlockState get(int index) {
        return (BlockState)this.states.get(index);
    }

    @Override
    public int calculateIndex(Map<Property<?>, ?> state) {
        if (state.size() != this.propertyEntries.size()) {
            throw new IllegalArgumentException(this.getDetailedPropertyMismatchException(state));
        }
        int index = 0;
        for (PropertyEntry entry : this.propertyEntries) {
            Object value = state.get(entry.property);
            if (value == null) {
                if (!state.containsKey(entry.property)) {
                    throw new IllegalArgumentException(this.getDetailedPropertyMismatchException(state));
                }
                throw new IllegalArgumentException("Null value for property " + entry.property.name());
            }
            int offset = entry.getOffsetForValueOrInvalid(value);
            if (offset == -1) {
                throw new IllegalArgumentException("Invalid value for property " + entry.property.name() + ": " + String.valueOf(value));
            }
            index += offset;
        }
        return index;
    }

    private String getDetailedPropertyMismatchException(Map<Property<?>, ?> state) {
        Set missingProperties = this.propertyEntries.stream().map(e -> e.property).filter(p -> !state.containsKey(p)).collect(Collectors.toSet());
        Set extraProperties = state.keySet().stream().filter(p -> this.propertyEntries.stream().noneMatch(e -> e.property == p)).collect(Collectors.toSet());
        StringBuilder errorMessage = new StringBuilder("State has incorrect number of properties.");
        if (!missingProperties.isEmpty()) {
            errorMessage.append(" Missing properties: ").append(missingProperties).append(".");
        }
        if (!extraProperties.isEmpty()) {
            errorMessage.append(" Extra properties: ").append(extraProperties).append(".");
        }
        return errorMessage.toString();
    }

    @Override
    public int updateIndexOrInvalid(int currentIndex, Property<?> property, Object oldValue, Object newValue) {
        if (currentIndex < 0 || currentIndex >= this.size()) {
            return -1;
        }
        for (PropertyEntry entry : this.propertyEntries) {
            if (entry.property != property) continue;
            int oldOffset = entry.getOffsetForValueOrInvalid(oldValue);
            int newOffset = entry.getOffsetForValueOrInvalid(newValue);
            if (oldOffset == -1 || newOffset == -1) {
                return -1;
            }
            return currentIndex - oldOffset + newOffset;
        }
        return -1;
    }

    @Immutable
    private record PropertyEntry(Property<?> property, ImmutableList<?> values, int stride) {
        int getOffsetForValueOrInvalid(Object value) {
            int valueIndex = this.values.indexOf(value);
            return valueIndex == -1 ? -1 : valueIndex * this.stride;
        }
    }
}

