/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit.fastutil.shorts;

import com.sk89q.worldedit.bukkit.fastutil.shorts.ShortComparator;
import java.io.Serializable;
import java.util.Comparator;

public final class ShortComparators {
    public static final ShortComparator NATURAL_COMPARATOR = new NaturalImplicitComparator();
    public static final ShortComparator OPPOSITE_COMPARATOR = new OppositeImplicitComparator();

    private ShortComparators() {
    }

    public static ShortComparator oppositeComparator(ShortComparator c2) {
        if (c2 instanceof OppositeComparator) {
            return ((OppositeComparator)c2).comparator;
        }
        return new OppositeComparator(c2);
    }

    public static ShortComparator asShortComparator(final Comparator<? super Short> c2) {
        if (c2 == null || c2 instanceof ShortComparator) {
            return (ShortComparator)c2;
        }
        return new ShortComparator(){

            @Override
            public int compare(short x, short y) {
                return c2.compare(x, y);
            }

            @Override
            public int compare(Short x, Short y) {
                return c2.compare(x, y);
            }
        };
    }

    protected static class OppositeComparator
    implements ShortComparator,
    Serializable {
        private static final long serialVersionUID = 1L;
        final ShortComparator comparator;

        protected OppositeComparator(ShortComparator c2) {
            this.comparator = c2;
        }

        @Override
        public final int compare(short a2, short b2) {
            return this.comparator.compare(b2, a2);
        }

        @Override
        public final ShortComparator reversed() {
            return this.comparator;
        }
    }

    protected static class NaturalImplicitComparator
    implements ShortComparator,
    Serializable {
        private static final long serialVersionUID = 1L;

        protected NaturalImplicitComparator() {
        }

        @Override
        public final int compare(short a2, short b2) {
            return Short.compare(a2, b2);
        }

        @Override
        public ShortComparator reversed() {
            return OPPOSITE_COMPARATOR;
        }

        private Object readResolve() {
            return NATURAL_COMPARATOR;
        }
    }

    protected static class OppositeImplicitComparator
    implements ShortComparator,
    Serializable {
        private static final long serialVersionUID = 1L;

        protected OppositeImplicitComparator() {
        }

        @Override
        public final int compare(short a2, short b2) {
            return -Short.compare(a2, b2);
        }

        @Override
        public ShortComparator reversed() {
            return NATURAL_COMPARATOR;
        }

        private Object readResolve() {
            return OPPOSITE_COMPARATOR;
        }
    }
}

