/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.registry.BlockMaterial;
import com.sk89q.worldedit.world.registry.BlockRegistry;
import com.sk89q.worldedit.world.registry.PassthroughBlockMaterial;
import java.util.HashMap;
import java.util.Map;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import org.bukkit.Material;

public class BukkitBlockRegistry
implements BlockRegistry {
    private final Map<Material, BukkitBlockMaterial> materialMap = new HashMap<Material, BukkitBlockMaterial>();

    @Override
    public Component getRichName(BlockType blockType) {
        if (WorldEditPlugin.getInstance().getBukkitImplAdapter() != null) {
            return WorldEditPlugin.getInstance().getBukkitImplAdapter().getRichBlockName(blockType);
        }
        return TextComponent.of(blockType.id());
    }

    @Override
    @Nullable
    public BlockMaterial getMaterial(BlockType blockType) {
        Material mat = BukkitAdapter.adapt(blockType);
        if (mat == null) {
            return null;
        }
        return this.materialMap.computeIfAbsent(mat, material -> {
            BlockMaterial platformMaterial = null;
            if (WorldEditPlugin.getInstance().getBukkitImplAdapter() != null) {
                platformMaterial = WorldEditPlugin.getInstance().getBukkitImplAdapter().getBlockMaterial(blockType);
            }
            return new BukkitBlockMaterial(platformMaterial, (Material)material);
        });
    }

    @Override
    @Nullable
    public Map<String, ? extends Property<?>> getProperties(BlockType blockType) {
        if (WorldEditPlugin.getInstance().getBukkitImplAdapter() != null) {
            return WorldEditPlugin.getInstance().getBukkitImplAdapter().getProperties(blockType);
        }
        return null;
    }

    @Override
    public OptionalInt getInternalBlockStateId(BlockState state) {
        if (WorldEditPlugin.getInstance().getBukkitImplAdapter() != null) {
            return WorldEditPlugin.getInstance().getBukkitImplAdapter().getInternalBlockStateId(state);
        }
        return OptionalInt.empty();
    }

    public static class BukkitBlockMaterial
    extends PassthroughBlockMaterial {
        private final Material material;

        public BukkitBlockMaterial(@Nullable BlockMaterial material, Material bukkitMaterial) {
            super(material);
            this.material = bukkitMaterial;
        }

        @Override
        public boolean isAir() {
            return this.material.isAir();
        }

        @Override
        public boolean isSolid() {
            return this.material.isSolid();
        }

        @Override
        public boolean isBurnable() {
            return this.material.isBurnable();
        }

        @Override
        public boolean isTranslucent() {
            return super.isTranslucent() || this.material.isTransparent();
        }
    }
}

