/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.wepif;

import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.wepif.PermissionsProvider;
import com.sk89q.wepif.PermissionsResolver;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;

public class PluginPermissionsResolver
implements PermissionsResolver {
    protected PermissionsProvider resolver;
    protected Plugin plugin;

    public static PermissionsResolver factory(Server server, YAMLProcessor config) {
        RegisteredServiceProvider serviceProvider = server.getServicesManager().getRegistration(PermissionsProvider.class);
        if (serviceProvider != null) {
            return new PluginPermissionsResolver((PermissionsProvider)serviceProvider.getProvider(), serviceProvider.getPlugin());
        }
        for (Plugin plugin : server.getPluginManager().getPlugins()) {
            if (!(plugin instanceof PermissionsProvider)) continue;
            PermissionsProvider permissionsProvider = (PermissionsProvider)plugin;
            return new PluginPermissionsResolver(permissionsProvider, plugin);
        }
        return null;
    }

    public PluginPermissionsResolver(PermissionsProvider resolver, Plugin permissionsPlugin) {
        this.resolver = resolver;
        this.plugin = permissionsPlugin;
    }

    @Override
    public void load() {
    }

    @Override
    public boolean hasPermission(String name, String permission) {
        return this.resolver.hasPermission(name, permission);
    }

    @Override
    public boolean hasPermission(String worldName, String name, String permission) {
        return this.resolver.hasPermission(worldName, name, permission);
    }

    @Override
    public boolean inGroup(String player, String group) {
        return this.resolver.inGroup(player, group);
    }

    @Override
    public String[] getGroups(String player) {
        return this.resolver.getGroups(player);
    }

    @Override
    public boolean hasPermission(OfflinePlayer player, String permission) {
        return this.resolver.hasPermission(player, permission);
    }

    @Override
    public boolean hasPermission(String worldName, OfflinePlayer player, String permission) {
        return this.resolver.hasPermission(worldName, player, permission);
    }

    @Override
    public boolean inGroup(OfflinePlayer player, String group) {
        return this.resolver.inGroup(player, group);
    }

    @Override
    public String[] getGroups(OfflinePlayer player) {
        return this.resolver.getGroups(player);
    }

    @Override
    public String getDetectionMessage() {
        return "Using plugin '" + this.plugin.getDescription().getName() + "' for permissions.";
    }
}

