/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.internal.schematic.backends;

import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.internal.schematic.backends.SchematicsBackend;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import com.sk89q.worldedit.util.io.file.FilenameException;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class PollingSchematicsBackend
implements SchematicsBackend {
    private static final Logger LOGGER = LogManagerCompat.getLogger();
    private static final Duration MAX_RESULT_AGE = Duration.ofSeconds(10L);
    private final Path schematicsDir;
    private Instant lastUpdateTs = Instant.EPOCH;
    private List<Path> schematics = new ArrayList<Path>();

    private PollingSchematicsBackend(Path schematicsDir) {
        this.schematicsDir = schematicsDir;
    }

    public static PollingSchematicsBackend create(Path schematicsFolder) {
        return new PollingSchematicsBackend(schematicsFolder);
    }

    private List<Path> scanFolder(Path root) {
        ArrayList<Path> pathList = new ArrayList<Path>();
        Path schematicRoot = WorldEdit.getInstance().getSchematicsManager().getRoot();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(root);){
            for (Path path : stream) {
                path = WorldEdit.getInstance().getSafeOpenFile(null, schematicRoot.toFile(), schematicRoot.relativize(path).toString(), null, new String[0]).toPath();
                if (Files.isDirectory(path, new LinkOption[0])) {
                    pathList.addAll(this.scanFolder(path));
                    continue;
                }
                pathList.add(path);
            }
        }
        catch (FilenameException | IOException e) {
            LOGGER.error((Object)e);
        }
        return pathList;
    }

    private void runRescan() {
        LOGGER.debug("Rescanning schematics");
        this.schematics = this.scanFolder(this.schematicsDir);
        this.lastUpdateTs = Instant.now();
    }

    @Override
    public void init() {
    }

    @Override
    public void uninit() {
    }

    @Override
    public synchronized Set<Path> getPaths() {
        Duration age = Duration.between(this.lastUpdateTs, Instant.now());
        if (age.compareTo(MAX_RESULT_AGE) >= 0) {
            this.runRescan();
        }
        return Set.copyOf(this.schematics);
    }

    @Override
    public synchronized void update() {
        this.lastUpdateTs = Instant.EPOCH;
    }
}

