/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.util.paste;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.sk89q.worldedit.util.paste.PasteMetadata;
import com.sk89q.worldedit.util.paste.Paster;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Map;
import java.util.concurrent.Callable;

public class EngineHubPaste
implements Paster {
    private static final Gson GSON = new Gson();

    @Override
    public Callable<URL> paste(String content, PasteMetadata metadata) {
        return new PasteTask(content, metadata);
    }

    private static final class PasteTask
    implements Callable<URL> {
        private final String content;
        private final PasteMetadata metadata;

        private PasteTask(String content, PasteMetadata metadata) {
            this.content = content;
            this.metadata = metadata;
        }

        @Override
        public URL call() throws IOException, InterruptedException {
            try (HttpClient client = HttpClient.newHttpClient();){
                HttpResponse<String> signResponse;
                HttpRequest.Builder signRequestBuilder = HttpRequest.newBuilder().uri(URI.create("https://paste.enginehub.org/signed_paste_v2")).header("x-paste-meta-from", "EngineHub");
                if (this.metadata.name != null) {
                    signRequestBuilder.header("x-paste-meta-name", this.metadata.name);
                }
                if (this.metadata.author != null) {
                    signRequestBuilder.header("x-paste-meta-author", this.metadata.author);
                }
                if (this.metadata.extension != null) {
                    signRequestBuilder.header("x-paste-meta-extension", this.metadata.extension);
                }
                if ((signResponse = client.send(signRequestBuilder.build(), HttpResponse.BodyHandlers.ofString())).statusCode() != 200) {
                    throw new IOException("Failed to initiate paste upload: " + signResponse.statusCode() + " " + signResponse.body());
                }
                SignedPasteResponse response = (SignedPasteResponse)GSON.fromJson(signResponse.body(), TypeToken.get(SignedPasteResponse.class).getType());
                HttpRequest.Builder uploadRequestBuilder = HttpRequest.newBuilder().uri(URI.create(response.uploadUrl)).method("PUT", HttpRequest.BodyPublishers.ofString(this.content));
                for (Map.Entry<String, String> entry : response.headers.entrySet()) {
                    uploadRequestBuilder.header(entry.getKey(), entry.getValue());
                }
                HttpResponse<String> uploadResponse = client.send(uploadRequestBuilder.build(), HttpResponse.BodyHandlers.ofString());
                if (uploadResponse.statusCode() != 200 && uploadResponse.statusCode() != 204) {
                    throw new IOException("Failed to upload paste: " + uploadResponse.statusCode() + " " + uploadResponse.body());
                }
                URL uRL = URI.create(response.viewUrl).toURL();
                return uRL;
            }
        }
    }

    private static final class SignedPasteResponse {
        String viewUrl;
        String uploadUrl;
        Map<String, String> headers;

        private SignedPasteResponse() {
        }
    }
}

