/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command.argument;

import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.internal.annotation.SchematicPath;
import com.sk89q.worldedit.internal.schematic.SchematicsManager;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.io.file.FilenameException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.converter.ArgumentConverter;
import org.enginehub.piston.converter.ConversionResult;
import org.enginehub.piston.converter.FailedConversion;
import org.enginehub.piston.converter.SuccessfulConversion;
import org.enginehub.piston.converter.SuggestionHelper;
import org.enginehub.piston.inject.InjectedValueAccess;
import org.enginehub.piston.inject.Key;

public class SchematicConverter
implements ArgumentConverter<Path> {
    private final WorldEdit worldEdit;
    private final TextComponent choices = TextComponent.of("schematic filename");

    public static void register(WorldEdit worldEdit, CommandManager commandManager) {
        commandManager.registerConverter(Key.of(Path.class, SchematicPath.class), new SchematicConverter(worldEdit));
    }

    private SchematicConverter(WorldEdit worldEdit) {
        this.worldEdit = worldEdit;
    }

    @Override
    public Component describeAcceptableArguments() {
        return this.choices;
    }

    @Override
    public List<String> getSuggestions(String input, InjectedValueAccess context) {
        SchematicsManager schematicsManager = this.worldEdit.getSchematicsManager();
        Path schematicsRootPath = schematicsManager.getRoot();
        return SuggestionHelper.limitByPrefix(schematicsManager.getSchematicPaths().stream().map(s -> schematicsRootPath.relativize((Path)s).toString()), input);
    }

    @Override
    public ConversionResult<Path> convert(String s, InjectedValueAccess injectedValueAccess) {
        Path schematicsRoot = this.worldEdit.getSchematicsManager().getRoot();
        Path schematicPath = schematicsRoot.resolve(s).toAbsolutePath();
        if (!schematicPath.startsWith(schematicsRoot)) {
            return FailedConversion.from(new FilenameException(s));
        }
        if (Files.exists(schematicPath, new LinkOption[0])) {
            schematicPath = schematicsRoot.relativize(schematicPath);
            return SuccessfulConversion.fromSingle(schematicPath);
        }
        return FailedConversion.from(new FilenameException(s));
    }
}

