/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command.argument;

import com.sk89q.worldedit.command.argument.SelectorChoiceOrList;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extension.platform.permission.ActorSelectorLimits;
import com.sk89q.worldedit.regions.RegionSelector;
import com.sk89q.worldedit.regions.selector.ConvexPolyhedralRegionSelector;
import com.sk89q.worldedit.regions.selector.CuboidRegionSelector;
import com.sk89q.worldedit.regions.selector.CylinderRegionSelector;
import com.sk89q.worldedit.regions.selector.EllipsoidRegionSelector;
import com.sk89q.worldedit.regions.selector.ExtendingCuboidRegionSelector;
import com.sk89q.worldedit.regions.selector.Polygonal2DRegionSelector;
import com.sk89q.worldedit.regions.selector.SphereRegionSelector;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.world.World;
import java.util.Optional;

public enum SelectorChoice implements SelectorChoiceOrList
{
    CUBOID("worldedit.select.cuboid.message"){

        @Override
        public RegionSelector createNewSelector(World world) {
            return new CuboidRegionSelector(world);
        }

        @Override
        public RegionSelector createNewSelector(RegionSelector oldSelector) {
            return new CuboidRegionSelector(oldSelector);
        }
    }
    ,
    EXTEND("worldedit.select.extend.message"){

        @Override
        public RegionSelector createNewSelector(World world) {
            return new ExtendingCuboidRegionSelector(world);
        }

        @Override
        public RegionSelector createNewSelector(RegionSelector oldSelector) {
            return new ExtendingCuboidRegionSelector(oldSelector);
        }
    }
    ,
    POLY("worldedit.select.poly.message"){

        @Override
        public RegionSelector createNewSelector(World world) {
            return new Polygonal2DRegionSelector(world);
        }

        @Override
        public RegionSelector createNewSelector(RegionSelector oldSelector) {
            return new Polygonal2DRegionSelector(oldSelector);
        }

        @Override
        public void explainNewSelector(Actor actor) {
            super.explainNewSelector(actor);
            Optional<Integer> limit = ActorSelectorLimits.forActor(actor).getPolygonVertexLimit();
            limit.ifPresent(integer -> actor.printInfo(TranslatableComponent.of("worldedit.select.poly.limit-message", TextComponent.of(integer))));
        }
    }
    ,
    ELLIPSOID("worldedit.select.ellipsoid.message"){

        @Override
        public RegionSelector createNewSelector(World world) {
            return new EllipsoidRegionSelector(world);
        }

        @Override
        public RegionSelector createNewSelector(RegionSelector oldSelector) {
            return new EllipsoidRegionSelector(oldSelector);
        }
    }
    ,
    SPHERE("worldedit.select.sphere.message"){

        @Override
        public RegionSelector createNewSelector(World world) {
            return new SphereRegionSelector(world);
        }

        @Override
        public RegionSelector createNewSelector(RegionSelector oldSelector) {
            return new SphereRegionSelector(oldSelector);
        }
    }
    ,
    CYL("worldedit.select.cyl.message"){

        @Override
        public RegionSelector createNewSelector(World world) {
            return new CylinderRegionSelector(world);
        }

        @Override
        public RegionSelector createNewSelector(RegionSelector oldSelector) {
            return new CylinderRegionSelector(oldSelector);
        }
    }
    ,
    CONVEX("worldedit.select.convex.message"){

        @Override
        public RegionSelector createNewSelector(World world) {
            return new ConvexPolyhedralRegionSelector(world);
        }

        @Override
        public RegionSelector createNewSelector(RegionSelector oldSelector) {
            return new ConvexPolyhedralRegionSelector(oldSelector);
        }

        @Override
        public void explainNewSelector(Actor actor) {
            super.explainNewSelector(actor);
            Optional<Integer> limit = ActorSelectorLimits.forActor(actor).getPolyhedronVertexLimit();
            limit.ifPresent(integer -> actor.printInfo(TranslatableComponent.of("worldedit.select.convex.limit-message", TextComponent.of(integer))));
        }
    };

    private final Component messageComponent;

    private SelectorChoice(String message) {
        this.messageComponent = TranslatableComponent.of(message);
    }

    public abstract RegionSelector createNewSelector(World var1);

    public abstract RegionSelector createNewSelector(RegionSelector var1);

    public void explainNewSelector(Actor actor) {
        actor.printInfo(this.messageComponent);
    }
}

