/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit.fastutil.objects;

import com.sk89q.worldedit.bukkit.fastutil.Arrays;
import com.sk89q.worldedit.bukkit.fastutil.Hash;
import com.sk89q.worldedit.bukkit.fastutil.ints.IntArrays;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Comparator;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.RecursiveAction;

public final class ObjectArrays {
    public static final Object[] EMPTY_ARRAY = new Object[0];
    public static final Object[] DEFAULT_EMPTY_ARRAY = new Object[0];
    private static final int QUICKSORT_NO_REC = 16;
    private static final int PARALLEL_QUICKSORT_NO_FORK = 8192;
    private static final int QUICKSORT_MEDIAN_OF_9 = 128;
    private static final int MERGESORT_NO_REC = 16;
    public static final Hash.Strategy HASH_STRATEGY = new ArrayHashStrategy();

    private ObjectArrays() {
    }

    private static <K> K[] newArray(K[] prototype, int length) {
        Class<?> klass = prototype.getClass();
        if (klass == Object[].class) {
            return length == 0 ? EMPTY_ARRAY : new Object[length];
        }
        return (Object[])Array.newInstance(klass.getComponentType(), length);
    }

    public static <K> K[] forceCapacity(K[] array, int length, int preserve) {
        K[] t = ObjectArrays.newArray(array, length);
        System.arraycopy(array, 0, t, 0, preserve);
        return t;
    }

    public static <K> K[] ensureCapacity(K[] array, int length) {
        return ObjectArrays.ensureCapacity(array, length, array.length);
    }

    public static <K> K[] ensureCapacity(K[] array, int length, int preserve) {
        return length > array.length ? ObjectArrays.forceCapacity(array, length, preserve) : array;
    }

    public static <K> K[] grow(K[] array, int length) {
        return ObjectArrays.grow(array, length, array.length);
    }

    public static <K> K[] grow(K[] array, int length, int preserve) {
        if (length > array.length) {
            int newLength = (int)Math.max(Math.min((long)array.length + (long)(array.length >> 1), 0x7FFFFFF7L), (long)length);
            K[] t = ObjectArrays.newArray(array, newLength);
            System.arraycopy(array, 0, t, 0, preserve);
            return t;
        }
        return array;
    }

    public static <K> K[] trim(K[] array, int length) {
        if (length >= array.length) {
            return array;
        }
        K[] t = ObjectArrays.newArray(array, length);
        System.arraycopy(array, 0, t, 0, length);
        return t;
    }

    public static <K> K[] setLength(K[] array, int length) {
        if (length == array.length) {
            return array;
        }
        if (length < array.length) {
            return ObjectArrays.trim(array, length);
        }
        return ObjectArrays.ensureCapacity(array, length);
    }

    public static <K> K[] copy(K[] array, int offset, int length) {
        ObjectArrays.ensureOffsetLength(array, offset, length);
        K[] a2 = ObjectArrays.newArray(array, length);
        System.arraycopy(array, offset, a2, 0, length);
        return a2;
    }

    public static <K> K[] copy(K[] array) {
        return (Object[])array.clone();
    }

    @Deprecated
    public static <K> void fill(K[] array, K value) {
        int i = array.length;
        while (i-- != 0) {
            array[i] = value;
        }
    }

    @Deprecated
    public static <K> void fill(K[] array, int from, int to, K value) {
        ObjectArrays.ensureFromTo(array, from, to);
        if (from == 0) {
            while (to-- != 0) {
                array[to] = value;
            }
        } else {
            for (int i = from; i < to; ++i) {
                array[i] = value;
            }
        }
    }

    @Deprecated
    public static <K> boolean equals(K[] a1, K[] a2) {
        int i = a1.length;
        if (i != a2.length) {
            return false;
        }
        while (i-- != 0) {
            if (Objects.equals(a1[i], a2[i])) continue;
            return false;
        }
        return true;
    }

    public static <K> void ensureFromTo(K[] a2, int from, int to) {
        Arrays.ensureFromTo(a2.length, from, to);
    }

    public static <K> void ensureOffsetLength(K[] a2, int offset, int length) {
        Arrays.ensureOffsetLength(a2.length, offset, length);
    }

    public static <K> void ensureSameLength(K[] a2, K[] b2) {
        if (a2.length != b2.length) {
            throw new IllegalArgumentException("Array size mismatch: " + a2.length + " != " + b2.length);
        }
    }

    private static ForkJoinPool getPool() {
        ForkJoinPool current = ForkJoinTask.getPool();
        return current == null ? ForkJoinPool.commonPool() : current;
    }

    public static <K> void swap(K[] x, int a2, int b2) {
        K t = x[a2];
        x[a2] = x[b2];
        x[b2] = t;
    }

    public static <K> void swap(K[] x, int a2, int b2, int n) {
        int i = 0;
        while (i < n) {
            ObjectArrays.swap(x, a2, b2);
            ++i;
            ++a2;
            ++b2;
        }
    }

    private static <K> int med3(K[] x, int a2, int b2, int c2, Comparator<K> comp) {
        int ab = comp.compare(x[a2], x[b2]);
        int ac = comp.compare(x[a2], x[c2]);
        int bc = comp.compare(x[b2], x[c2]);
        return ab < 0 ? (bc < 0 ? b2 : (ac < 0 ? c2 : a2)) : (bc > 0 ? b2 : (ac > 0 ? c2 : a2));
    }

    private static <K> void selectionSort(K[] a2, int from, int to, Comparator<K> comp) {
        for (int i = from; i < to - 1; ++i) {
            int m = i;
            for (int j = i + 1; j < to; ++j) {
                if (comp.compare(a2[j], a2[m]) >= 0) continue;
                m = j;
            }
            if (m == i) continue;
            K u = a2[i];
            a2[i] = a2[m];
            a2[m] = u;
        }
    }

    private static <K> void insertionSort(K[] a2, int from, int to, Comparator<K> comp) {
        int i = from;
        while (++i < to) {
            K t = a2[i];
            int j = i;
            K u = a2[j - 1];
            while (comp.compare(t, u) < 0) {
                a2[j] = u;
                if (from == j - 1) {
                    --j;
                    break;
                }
                u = a2[--j - 1];
            }
            a2[j] = t;
        }
    }

    public static <K> void quickSort(K[] x, int from, int to, Comparator<K> comp) {
        int c2;
        int a2;
        int len = to - from;
        if (len < 16) {
            ObjectArrays.selectionSort(x, from, to, comp);
            return;
        }
        int m = from + len / 2;
        int l = from;
        int n = to - 1;
        if (len > 128) {
            int s = len / 8;
            l = ObjectArrays.med3(x, l, l + s, l + 2 * s, comp);
            m = ObjectArrays.med3(x, m - s, m, m + s, comp);
            n = ObjectArrays.med3(x, n - 2 * s, n - s, n, comp);
        }
        m = ObjectArrays.med3(x, l, m, n, comp);
        K v = x[m];
        int b2 = a2 = from;
        int d2 = c2 = to - 1;
        while (true) {
            int comparison;
            if (b2 <= c2 && (comparison = comp.compare(x[b2], v)) <= 0) {
                if (comparison == 0) {
                    ObjectArrays.swap(x, a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c2 >= b2 && (comparison = comp.compare(x[c2], v)) >= 0) {
                if (comparison == 0) {
                    ObjectArrays.swap(x, c2, d2--);
                }
                --c2;
            }
            if (b2 > c2) break;
            ObjectArrays.swap(x, b2++, c2--);
        }
        int s = Math.min(a2 - from, b2 - a2);
        ObjectArrays.swap(x, from, b2 - s, s);
        s = Math.min(d2 - c2, to - d2 - 1);
        ObjectArrays.swap(x, b2, to - s, s);
        s = b2 - a2;
        if (s > 1) {
            ObjectArrays.quickSort(x, from, from + s, comp);
        }
        if ((s = d2 - c2) > 1) {
            ObjectArrays.quickSort(x, to - s, to, comp);
        }
    }

    public static <K> void quickSort(K[] x, Comparator<K> comp) {
        ObjectArrays.quickSort(x, 0, x.length, comp);
    }

    public static <K> void parallelQuickSort(K[] x, int from, int to, Comparator<K> comp) {
        ForkJoinPool pool = ObjectArrays.getPool();
        if (to - from < 8192 || pool.getParallelism() == 1) {
            ObjectArrays.quickSort(x, from, to, comp);
        } else {
            pool.invoke(new ForkJoinQuickSortComp<K>(x, from, to, comp));
        }
    }

    public static <K> void parallelQuickSort(K[] x, Comparator<K> comp) {
        ObjectArrays.parallelQuickSort(x, 0, x.length, comp);
    }

    private static <K> int med3(K[] x, int a2, int b2, int c2) {
        int ab = ((Comparable)x[a2]).compareTo(x[b2]);
        int ac = ((Comparable)x[a2]).compareTo(x[c2]);
        int bc = ((Comparable)x[b2]).compareTo(x[c2]);
        return ab < 0 ? (bc < 0 ? b2 : (ac < 0 ? c2 : a2)) : (bc > 0 ? b2 : (ac > 0 ? c2 : a2));
    }

    private static <K> void selectionSort(K[] a2, int from, int to) {
        for (int i = from; i < to - 1; ++i) {
            int m = i;
            for (int j = i + 1; j < to; ++j) {
                if (((Comparable)a2[j]).compareTo(a2[m]) >= 0) continue;
                m = j;
            }
            if (m == i) continue;
            K u = a2[i];
            a2[i] = a2[m];
            a2[m] = u;
        }
    }

    private static <K> void insertionSort(K[] a2, int from, int to) {
        int i = from;
        while (++i < to) {
            K t = a2[i];
            int j = i;
            K u = a2[j - 1];
            while (((Comparable)t).compareTo(u) < 0) {
                a2[j] = u;
                if (from == j - 1) {
                    --j;
                    break;
                }
                u = a2[--j - 1];
            }
            a2[j] = t;
        }
    }

    public static <K> void quickSort(K[] x, int from, int to) {
        int c2;
        int a2;
        int len = to - from;
        if (len < 16) {
            ObjectArrays.selectionSort(x, from, to);
            return;
        }
        int m = from + len / 2;
        int l = from;
        int n = to - 1;
        if (len > 128) {
            int s = len / 8;
            l = ObjectArrays.med3(x, l, l + s, l + 2 * s);
            m = ObjectArrays.med3(x, m - s, m, m + s);
            n = ObjectArrays.med3(x, n - 2 * s, n - s, n);
        }
        m = ObjectArrays.med3(x, l, m, n);
        K v = x[m];
        int b2 = a2 = from;
        int d2 = c2 = to - 1;
        while (true) {
            int comparison;
            if (b2 <= c2 && (comparison = ((Comparable)x[b2]).compareTo(v)) <= 0) {
                if (comparison == 0) {
                    ObjectArrays.swap(x, a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c2 >= b2 && (comparison = ((Comparable)x[c2]).compareTo(v)) >= 0) {
                if (comparison == 0) {
                    ObjectArrays.swap(x, c2, d2--);
                }
                --c2;
            }
            if (b2 > c2) break;
            ObjectArrays.swap(x, b2++, c2--);
        }
        int s = Math.min(a2 - from, b2 - a2);
        ObjectArrays.swap(x, from, b2 - s, s);
        s = Math.min(d2 - c2, to - d2 - 1);
        ObjectArrays.swap(x, b2, to - s, s);
        s = b2 - a2;
        if (s > 1) {
            ObjectArrays.quickSort(x, from, from + s);
        }
        if ((s = d2 - c2) > 1) {
            ObjectArrays.quickSort(x, to - s, to);
        }
    }

    public static <K> void quickSort(K[] x) {
        ObjectArrays.quickSort(x, 0, x.length);
    }

    public static <K> void parallelQuickSort(K[] x, int from, int to) {
        ForkJoinPool pool = ObjectArrays.getPool();
        if (to - from < 8192 || pool.getParallelism() == 1) {
            ObjectArrays.quickSort(x, from, to);
        } else {
            pool.invoke(new ForkJoinQuickSort<K>(x, from, to));
        }
    }

    public static <K> void parallelQuickSort(K[] x) {
        ObjectArrays.parallelQuickSort(x, 0, x.length);
    }

    private static <K> int med3Indirect(int[] perm, K[] x, int a2, int b2, int c2) {
        K aa = x[perm[a2]];
        K bb = x[perm[b2]];
        K cc = x[perm[c2]];
        int ab = ((Comparable)aa).compareTo(bb);
        int ac = ((Comparable)aa).compareTo(cc);
        int bc = ((Comparable)bb).compareTo(cc);
        return ab < 0 ? (bc < 0 ? b2 : (ac < 0 ? c2 : a2)) : (bc > 0 ? b2 : (ac > 0 ? c2 : a2));
    }

    private static <K> void insertionSortIndirect(int[] perm, K[] a2, int from, int to) {
        int i = from;
        while (++i < to) {
            int t = perm[i];
            int j = i;
            int u = perm[j - 1];
            while (((Comparable)a2[t]).compareTo(a2[u]) < 0) {
                perm[j] = u;
                if (from == j - 1) {
                    --j;
                    break;
                }
                u = perm[--j - 1];
            }
            perm[j] = t;
        }
    }

    public static <K> void quickSortIndirect(int[] perm, K[] x, int from, int to) {
        int c2;
        int a2;
        int len = to - from;
        if (len < 16) {
            ObjectArrays.insertionSortIndirect(perm, x, from, to);
            return;
        }
        int m = from + len / 2;
        int l = from;
        int n = to - 1;
        if (len > 128) {
            int s = len / 8;
            l = ObjectArrays.med3Indirect(perm, x, l, l + s, l + 2 * s);
            m = ObjectArrays.med3Indirect(perm, x, m - s, m, m + s);
            n = ObjectArrays.med3Indirect(perm, x, n - 2 * s, n - s, n);
        }
        m = ObjectArrays.med3Indirect(perm, x, l, m, n);
        K v = x[perm[m]];
        int b2 = a2 = from;
        int d2 = c2 = to - 1;
        while (true) {
            int comparison;
            if (b2 <= c2 && (comparison = ((Comparable)x[perm[b2]]).compareTo(v)) <= 0) {
                if (comparison == 0) {
                    IntArrays.swap(perm, a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c2 >= b2 && (comparison = ((Comparable)x[perm[c2]]).compareTo(v)) >= 0) {
                if (comparison == 0) {
                    IntArrays.swap(perm, c2, d2--);
                }
                --c2;
            }
            if (b2 > c2) break;
            IntArrays.swap(perm, b2++, c2--);
        }
        int s = Math.min(a2 - from, b2 - a2);
        IntArrays.swap(perm, from, b2 - s, s);
        s = Math.min(d2 - c2, to - d2 - 1);
        IntArrays.swap(perm, b2, to - s, s);
        s = b2 - a2;
        if (s > 1) {
            ObjectArrays.quickSortIndirect(perm, x, from, from + s);
        }
        if ((s = d2 - c2) > 1) {
            ObjectArrays.quickSortIndirect(perm, x, to - s, to);
        }
    }

    public static <K> void quickSortIndirect(int[] perm, K[] x) {
        ObjectArrays.quickSortIndirect(perm, x, 0, x.length);
    }

    public static <K> void parallelQuickSortIndirect(int[] perm, K[] x, int from, int to) {
        ForkJoinPool pool = ObjectArrays.getPool();
        if (to - from < 8192 || pool.getParallelism() == 1) {
            ObjectArrays.quickSortIndirect(perm, x, from, to);
        } else {
            pool.invoke(new ForkJoinQuickSortIndirect<K>(perm, x, from, to));
        }
    }

    public static <K> void parallelQuickSortIndirect(int[] perm, K[] x) {
        ObjectArrays.parallelQuickSortIndirect(perm, x, 0, x.length);
    }

    public static <K> void stabilize(int[] perm, K[] x, int from, int to) {
        int curr = from;
        for (int i = from + 1; i < to; ++i) {
            if (x[perm[i]] == x[perm[curr]]) continue;
            if (i - curr > 1) {
                IntArrays.parallelQuickSort(perm, curr, i);
            }
            curr = i;
        }
        if (to - curr > 1) {
            IntArrays.parallelQuickSort(perm, curr, to);
        }
    }

    public static <K> void stabilize(int[] perm, K[] x) {
        ObjectArrays.stabilize(perm, x, 0, perm.length);
    }

    private static <K> int med3(K[] x, K[] y, int a2, int b2, int c2) {
        int bc;
        int t = ((Comparable)x[a2]).compareTo(x[b2]);
        int ab = t == 0 ? ((Comparable)y[a2]).compareTo(y[b2]) : t;
        t = ((Comparable)x[a2]).compareTo(x[c2]);
        int ac = t == 0 ? ((Comparable)y[a2]).compareTo(y[c2]) : t;
        t = ((Comparable)x[b2]).compareTo(x[c2]);
        int n = bc = t == 0 ? ((Comparable)y[b2]).compareTo(y[c2]) : t;
        return ab < 0 ? (bc < 0 ? b2 : (ac < 0 ? c2 : a2)) : (bc > 0 ? b2 : (ac > 0 ? c2 : a2));
    }

    private static <K> void swap(K[] x, K[] y, int a2, int b2) {
        K t = x[a2];
        K u = y[a2];
        x[a2] = x[b2];
        y[a2] = y[b2];
        x[b2] = t;
        y[b2] = u;
    }

    private static <K> void swap(K[] x, K[] y, int a2, int b2, int n) {
        int i = 0;
        while (i < n) {
            ObjectArrays.swap(x, y, a2, b2);
            ++i;
            ++a2;
            ++b2;
        }
    }

    private static <K> void selectionSort(K[] a2, K[] b2, int from, int to) {
        for (int i = from; i < to - 1; ++i) {
            int m = i;
            for (int j = i + 1; j < to; ++j) {
                int u = ((Comparable)a2[j]).compareTo(a2[m]);
                if (u >= 0 && (u != 0 || ((Comparable)b2[j]).compareTo(b2[m]) >= 0)) continue;
                m = j;
            }
            if (m == i) continue;
            K t = a2[i];
            a2[i] = a2[m];
            a2[m] = t;
            t = b2[i];
            b2[i] = b2[m];
            b2[m] = t;
        }
    }

    public static <K> void quickSort(K[] x, K[] y, int from, int to) {
        int c2;
        int a2;
        int len = to - from;
        if (len < 16) {
            ObjectArrays.selectionSort(x, y, from, to);
            return;
        }
        int m = from + len / 2;
        int l = from;
        int n = to - 1;
        if (len > 128) {
            int s = len / 8;
            l = ObjectArrays.med3(x, y, l, l + s, l + 2 * s);
            m = ObjectArrays.med3(x, y, m - s, m, m + s);
            n = ObjectArrays.med3(x, y, n - 2 * s, n - s, n);
        }
        m = ObjectArrays.med3(x, y, l, m, n);
        K v = x[m];
        K w = y[m];
        int b2 = a2 = from;
        int d2 = c2 = to - 1;
        while (true) {
            int t;
            int comparison;
            if (b2 <= c2 && (comparison = (t = ((Comparable)x[b2]).compareTo(v)) == 0 ? ((Comparable)y[b2]).compareTo(w) : t) <= 0) {
                if (comparison == 0) {
                    ObjectArrays.swap(x, y, a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c2 >= b2 && (comparison = (t = ((Comparable)x[c2]).compareTo(v)) == 0 ? ((Comparable)y[c2]).compareTo(w) : t) >= 0) {
                if (comparison == 0) {
                    ObjectArrays.swap(x, y, c2, d2--);
                }
                --c2;
            }
            if (b2 > c2) break;
            ObjectArrays.swap(x, y, b2++, c2--);
        }
        int s = Math.min(a2 - from, b2 - a2);
        ObjectArrays.swap(x, y, from, b2 - s, s);
        s = Math.min(d2 - c2, to - d2 - 1);
        ObjectArrays.swap(x, y, b2, to - s, s);
        s = b2 - a2;
        if (s > 1) {
            ObjectArrays.quickSort(x, y, from, from + s);
        }
        if ((s = d2 - c2) > 1) {
            ObjectArrays.quickSort(x, y, to - s, to);
        }
    }

    public static <K> void quickSort(K[] x, K[] y) {
        ObjectArrays.ensureSameLength(x, y);
        ObjectArrays.quickSort(x, y, 0, x.length);
    }

    public static <K> void parallelQuickSort(K[] x, K[] y, int from, int to) {
        ForkJoinPool pool = ObjectArrays.getPool();
        if (to - from < 8192 || pool.getParallelism() == 1) {
            ObjectArrays.quickSort(x, y, from, to);
        } else {
            pool.invoke(new ForkJoinQuickSort2<K>(x, y, from, to));
        }
    }

    public static <K> void parallelQuickSort(K[] x, K[] y) {
        ObjectArrays.ensureSameLength(x, y);
        ObjectArrays.parallelQuickSort(x, y, 0, x.length);
    }

    public static <K> void unstableSort(K[] a2, int from, int to) {
        ObjectArrays.quickSort(a2, from, to);
    }

    public static <K> void unstableSort(K[] a2) {
        ObjectArrays.unstableSort(a2, 0, a2.length);
    }

    public static <K> void unstableSort(K[] a2, int from, int to, Comparator<K> comp) {
        ObjectArrays.quickSort(a2, from, to, comp);
    }

    public static <K> void unstableSort(K[] a2, Comparator<K> comp) {
        ObjectArrays.unstableSort(a2, 0, a2.length, comp);
    }

    public static <K> void mergeSort(K[] a2, int from, int to, K[] supp) {
        int len = to - from;
        if (len < 16) {
            ObjectArrays.insertionSort(a2, from, to);
            return;
        }
        if (supp == null) {
            supp = java.util.Arrays.copyOf(a2, to);
        }
        int mid = from + to >>> 1;
        ObjectArrays.mergeSort(supp, from, mid, a2);
        ObjectArrays.mergeSort(supp, mid, to, a2);
        if (((Comparable)supp[mid - 1]).compareTo(supp[mid]) <= 0) {
            System.arraycopy(supp, from, a2, from, len);
            return;
        }
        int p = from;
        int q = mid;
        for (int i = from; i < to; ++i) {
            a2[i] = q >= to || p < mid && ((Comparable)supp[p]).compareTo(supp[q]) <= 0 ? supp[p++] : supp[q++];
        }
    }

    public static <K> void mergeSort(K[] a2, int from, int to) {
        ObjectArrays.mergeSort(a2, from, to, (Object[])null);
    }

    public static <K> void mergeSort(K[] a2) {
        ObjectArrays.mergeSort(a2, 0, a2.length);
    }

    public static <K> void mergeSort(K[] a2, int from, int to, Comparator<K> comp, K[] supp) {
        int len = to - from;
        if (len < 16) {
            ObjectArrays.insertionSort(a2, from, to, comp);
            return;
        }
        if (supp == null) {
            supp = java.util.Arrays.copyOf(a2, to);
        }
        int mid = from + to >>> 1;
        ObjectArrays.mergeSort(supp, from, mid, comp, a2);
        ObjectArrays.mergeSort(supp, mid, to, comp, a2);
        if (comp.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from, a2, from, len);
            return;
        }
        int p = from;
        int q = mid;
        for (int i = from; i < to; ++i) {
            a2[i] = q >= to || p < mid && comp.compare(supp[p], supp[q]) <= 0 ? supp[p++] : supp[q++];
        }
    }

    public static <K> void mergeSort(K[] a2, int from, int to, Comparator<K> comp) {
        ObjectArrays.mergeSort(a2, from, to, comp, null);
    }

    public static <K> void mergeSort(K[] a2, Comparator<K> comp) {
        ObjectArrays.mergeSort(a2, 0, a2.length, comp);
    }

    public static <K> void stableSort(K[] a2, int from, int to) {
        java.util.Arrays.sort(a2, from, to);
    }

    public static <K> void stableSort(K[] a2) {
        ObjectArrays.stableSort(a2, 0, a2.length);
    }

    public static <K> void stableSort(K[] a2, int from, int to, Comparator<K> comp) {
        java.util.Arrays.sort(a2, from, to, comp);
    }

    public static <K> void stableSort(K[] a2, Comparator<K> comp) {
        ObjectArrays.stableSort(a2, 0, a2.length, comp);
    }

    public static <K> int binarySearch(K[] a2, int from, int to, K key) {
        --to;
        while (from <= to) {
            int mid = from + to >>> 1;
            K midVal = a2[mid];
            int cmp = ((Comparable)midVal).compareTo(key);
            if (cmp < 0) {
                from = mid + 1;
                continue;
            }
            if (cmp > 0) {
                to = mid - 1;
                continue;
            }
            return mid;
        }
        return -(from + 1);
    }

    public static <K> int binarySearch(K[] a2, K key) {
        return ObjectArrays.binarySearch(a2, 0, a2.length, key);
    }

    public static <K> int binarySearch(K[] a2, int from, int to, K key, Comparator<K> c2) {
        --to;
        while (from <= to) {
            int mid = from + to >>> 1;
            K midVal = a2[mid];
            int cmp = c2.compare(midVal, key);
            if (cmp < 0) {
                from = mid + 1;
                continue;
            }
            if (cmp > 0) {
                to = mid - 1;
                continue;
            }
            return mid;
        }
        return -(from + 1);
    }

    public static <K> int binarySearch(K[] a2, K key, Comparator<K> c2) {
        return ObjectArrays.binarySearch(a2, 0, a2.length, key, c2);
    }

    public static <K> K[] shuffle(K[] a2, int from, int to, Random random) {
        int i = to - from;
        while (i-- != 0) {
            int p = random.nextInt(i + 1);
            K t = a2[from + i];
            a2[from + i] = a2[from + p];
            a2[from + p] = t;
        }
        return a2;
    }

    public static <K> K[] shuffle(K[] a2, Random random) {
        int i = a2.length;
        while (i-- != 0) {
            int p = random.nextInt(i + 1);
            K t = a2[i];
            a2[i] = a2[p];
            a2[p] = t;
        }
        return a2;
    }

    public static <K> K[] reverse(K[] a2) {
        int length = a2.length;
        int i = length / 2;
        while (i-- != 0) {
            K t = a2[length - i - 1];
            a2[length - i - 1] = a2[i];
            a2[i] = t;
        }
        return a2;
    }

    public static <K> K[] reverse(K[] a2, int from, int to) {
        int length = to - from;
        int i = length / 2;
        while (i-- != 0) {
            K t = a2[from + length - i - 1];
            a2[from + length - i - 1] = a2[from + i];
            a2[from + i] = t;
        }
        return a2;
    }

    protected static class ForkJoinQuickSortComp<K>
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        private final int from;
        private final int to;
        private final K[] x;
        private final Comparator<K> comp;

        public ForkJoinQuickSortComp(K[] x, int from, int to, Comparator<K> comp) {
            this.from = from;
            this.to = to;
            this.x = x;
            this.comp = comp;
        }

        @Override
        protected void compute() {
            int c2;
            int a2;
            Object[] x = this.x;
            int len = this.to - this.from;
            if (len < 8192) {
                ObjectArrays.quickSort(x, this.from, this.to, this.comp);
                return;
            }
            int m = this.from + len / 2;
            int l = this.from;
            int n = this.to - 1;
            int s = len / 8;
            l = ObjectArrays.med3(x, l, l + s, l + 2 * s, this.comp);
            m = ObjectArrays.med3(x, m - s, m, m + s, this.comp);
            n = ObjectArrays.med3(x, n - 2 * s, n - s, n, this.comp);
            m = ObjectArrays.med3(x, l, m, n, this.comp);
            Object v = x[m];
            int b2 = a2 = this.from;
            int d2 = c2 = this.to - 1;
            while (true) {
                int comparison;
                if (b2 <= c2 && (comparison = this.comp.compare(x[b2], v)) <= 0) {
                    if (comparison == 0) {
                        ObjectArrays.swap(x, a2++, b2);
                    }
                    ++b2;
                    continue;
                }
                while (c2 >= b2 && (comparison = this.comp.compare(x[c2], v)) >= 0) {
                    if (comparison == 0) {
                        ObjectArrays.swap(x, c2, d2--);
                    }
                    --c2;
                }
                if (b2 > c2) break;
                ObjectArrays.swap(x, b2++, c2--);
            }
            s = Math.min(a2 - this.from, b2 - a2);
            ObjectArrays.swap(x, this.from, b2 - s, s);
            s = Math.min(d2 - c2, this.to - d2 - 1);
            ObjectArrays.swap(x, b2, this.to - s, s);
            s = b2 - a2;
            int t = d2 - c2;
            if (s > 1 && t > 1) {
                ForkJoinQuickSortComp.invokeAll(new ForkJoinQuickSortComp<Object>(x, this.from, this.from + s, this.comp), new ForkJoinQuickSortComp<Object>(x, this.to - t, this.to, this.comp));
            } else if (s > 1) {
                ForkJoinQuickSortComp.invokeAll(new ForkJoinQuickSortComp<Object>(x, this.from, this.from + s, this.comp));
            } else {
                ForkJoinQuickSortComp.invokeAll(new ForkJoinQuickSortComp<Object>(x, this.to - t, this.to, this.comp));
            }
        }
    }

    protected static class ForkJoinQuickSort<K>
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        private final int from;
        private final int to;
        private final K[] x;

        public ForkJoinQuickSort(K[] x, int from, int to) {
            this.from = from;
            this.to = to;
            this.x = x;
        }

        @Override
        protected void compute() {
            int c2;
            int a2;
            Object[] x = this.x;
            int len = this.to - this.from;
            if (len < 8192) {
                ObjectArrays.quickSort(x, this.from, this.to);
                return;
            }
            int m = this.from + len / 2;
            int l = this.from;
            int n = this.to - 1;
            int s = len / 8;
            l = ObjectArrays.med3(x, l, l + s, l + 2 * s);
            m = ObjectArrays.med3(x, m - s, m, m + s);
            n = ObjectArrays.med3(x, n - 2 * s, n - s, n);
            m = ObjectArrays.med3(x, l, m, n);
            Object v = x[m];
            int b2 = a2 = this.from;
            int d2 = c2 = this.to - 1;
            while (true) {
                int comparison;
                if (b2 <= c2 && (comparison = ((Comparable)x[b2]).compareTo(v)) <= 0) {
                    if (comparison == 0) {
                        ObjectArrays.swap(x, a2++, b2);
                    }
                    ++b2;
                    continue;
                }
                while (c2 >= b2 && (comparison = ((Comparable)x[c2]).compareTo(v)) >= 0) {
                    if (comparison == 0) {
                        ObjectArrays.swap(x, c2, d2--);
                    }
                    --c2;
                }
                if (b2 > c2) break;
                ObjectArrays.swap(x, b2++, c2--);
            }
            s = Math.min(a2 - this.from, b2 - a2);
            ObjectArrays.swap(x, this.from, b2 - s, s);
            s = Math.min(d2 - c2, this.to - d2 - 1);
            ObjectArrays.swap(x, b2, this.to - s, s);
            s = b2 - a2;
            int t = d2 - c2;
            if (s > 1 && t > 1) {
                ForkJoinQuickSort.invokeAll(new ForkJoinQuickSort<Object>(x, this.from, this.from + s), new ForkJoinQuickSort<Object>(x, this.to - t, this.to));
            } else if (s > 1) {
                ForkJoinQuickSort.invokeAll(new ForkJoinQuickSort<Object>(x, this.from, this.from + s));
            } else {
                ForkJoinQuickSort.invokeAll(new ForkJoinQuickSort<Object>(x, this.to - t, this.to));
            }
        }
    }

    protected static class ForkJoinQuickSortIndirect<K>
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        private final int from;
        private final int to;
        private final int[] perm;
        private final K[] x;

        public ForkJoinQuickSortIndirect(int[] perm, K[] x, int from, int to) {
            this.from = from;
            this.to = to;
            this.x = x;
            this.perm = perm;
        }

        @Override
        protected void compute() {
            int c2;
            int a2;
            Object[] x = this.x;
            int len = this.to - this.from;
            if (len < 8192) {
                ObjectArrays.quickSortIndirect(this.perm, x, this.from, this.to);
                return;
            }
            int m = this.from + len / 2;
            int l = this.from;
            int n = this.to - 1;
            int s = len / 8;
            l = ObjectArrays.med3Indirect(this.perm, x, l, l + s, l + 2 * s);
            m = ObjectArrays.med3Indirect(this.perm, x, m - s, m, m + s);
            n = ObjectArrays.med3Indirect(this.perm, x, n - 2 * s, n - s, n);
            m = ObjectArrays.med3Indirect(this.perm, x, l, m, n);
            Object v = x[this.perm[m]];
            int b2 = a2 = this.from;
            int d2 = c2 = this.to - 1;
            while (true) {
                int comparison;
                if (b2 <= c2 && (comparison = ((Comparable)x[this.perm[b2]]).compareTo(v)) <= 0) {
                    if (comparison == 0) {
                        IntArrays.swap(this.perm, a2++, b2);
                    }
                    ++b2;
                    continue;
                }
                while (c2 >= b2 && (comparison = ((Comparable)x[this.perm[c2]]).compareTo(v)) >= 0) {
                    if (comparison == 0) {
                        IntArrays.swap(this.perm, c2, d2--);
                    }
                    --c2;
                }
                if (b2 > c2) break;
                IntArrays.swap(this.perm, b2++, c2--);
            }
            s = Math.min(a2 - this.from, b2 - a2);
            IntArrays.swap(this.perm, this.from, b2 - s, s);
            s = Math.min(d2 - c2, this.to - d2 - 1);
            IntArrays.swap(this.perm, b2, this.to - s, s);
            s = b2 - a2;
            int t = d2 - c2;
            if (s > 1 && t > 1) {
                ForkJoinQuickSortIndirect.invokeAll(new ForkJoinQuickSortIndirect<Object>(this.perm, x, this.from, this.from + s), new ForkJoinQuickSortIndirect<Object>(this.perm, x, this.to - t, this.to));
            } else if (s > 1) {
                ForkJoinQuickSortIndirect.invokeAll(new ForkJoinQuickSortIndirect<Object>(this.perm, x, this.from, this.from + s));
            } else {
                ForkJoinQuickSortIndirect.invokeAll(new ForkJoinQuickSortIndirect<Object>(this.perm, x, this.to - t, this.to));
            }
        }
    }

    protected static class ForkJoinQuickSort2<K>
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        private final int from;
        private final int to;
        private final K[] x;
        private final K[] y;

        public ForkJoinQuickSort2(K[] x, K[] y, int from, int to) {
            this.from = from;
            this.to = to;
            this.x = x;
            this.y = y;
        }

        @Override
        protected void compute() {
            int c2;
            int a2;
            Object[] x = this.x;
            Object[] y = this.y;
            int len = this.to - this.from;
            if (len < 8192) {
                ObjectArrays.quickSort(x, y, this.from, this.to);
                return;
            }
            int m = this.from + len / 2;
            int l = this.from;
            int n = this.to - 1;
            int s = len / 8;
            l = ObjectArrays.med3(x, y, l, l + s, l + 2 * s);
            m = ObjectArrays.med3(x, y, m - s, m, m + s);
            n = ObjectArrays.med3(x, y, n - 2 * s, n - s, n);
            m = ObjectArrays.med3(x, y, l, m, n);
            Object v = x[m];
            Object w = y[m];
            int b2 = a2 = this.from;
            int d2 = c2 = this.to - 1;
            while (true) {
                int t;
                int comparison;
                if (b2 <= c2 && (comparison = (t = ((Comparable)x[b2]).compareTo(v)) == 0 ? ((Comparable)y[b2]).compareTo(w) : t) <= 0) {
                    if (comparison == 0) {
                        ObjectArrays.swap(x, y, a2++, b2);
                    }
                    ++b2;
                    continue;
                }
                while (c2 >= b2 && (comparison = (t = ((Comparable)x[c2]).compareTo(v)) == 0 ? ((Comparable)y[c2]).compareTo(w) : t) >= 0) {
                    if (comparison == 0) {
                        ObjectArrays.swap(x, y, c2, d2--);
                    }
                    --c2;
                }
                if (b2 > c2) break;
                ObjectArrays.swap(x, y, b2++, c2--);
            }
            s = Math.min(a2 - this.from, b2 - a2);
            ObjectArrays.swap(x, y, this.from, b2 - s, s);
            s = Math.min(d2 - c2, this.to - d2 - 1);
            ObjectArrays.swap(x, y, b2, this.to - s, s);
            s = b2 - a2;
            int t = d2 - c2;
            if (s > 1 && t > 1) {
                ForkJoinQuickSort2.invokeAll(new ForkJoinQuickSort2<Object>(x, y, this.from, this.from + s), new ForkJoinQuickSort2<Object>(x, y, this.to - t, this.to));
            } else if (s > 1) {
                ForkJoinQuickSort2.invokeAll(new ForkJoinQuickSort2<Object>(x, y, this.from, this.from + s));
            } else {
                ForkJoinQuickSort2.invokeAll(new ForkJoinQuickSort2<Object>(x, y, this.to - t, this.to));
            }
        }
    }

    private static final class ArrayHashStrategy<K>
    implements Hash.Strategy<K[]>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        private ArrayHashStrategy() {
        }

        @Override
        public int hashCode(K[] o) {
            return java.util.Arrays.hashCode(o);
        }

        @Override
        public boolean equals(K[] a2, K[] b2) {
            return java.util.Arrays.equals(a2, b2);
        }
    }
}

