/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit.fastutil.longs;

import com.sk89q.worldedit.bukkit.fastutil.longs.LongComparator;
import java.io.Serializable;
import java.util.Comparator;

public final class LongComparators {
    public static final LongComparator NATURAL_COMPARATOR = new NaturalImplicitComparator();
    public static final LongComparator OPPOSITE_COMPARATOR = new OppositeImplicitComparator();

    private LongComparators() {
    }

    public static LongComparator oppositeComparator(LongComparator c2) {
        if (c2 instanceof OppositeComparator) {
            return ((OppositeComparator)c2).comparator;
        }
        return new OppositeComparator(c2);
    }

    public static LongComparator asLongComparator(final Comparator<? super Long> c2) {
        if (c2 == null || c2 instanceof LongComparator) {
            return (LongComparator)c2;
        }
        return new LongComparator(){

            @Override
            public int compare(long x, long y) {
                return c2.compare(x, y);
            }

            @Override
            public int compare(Long x, Long y) {
                return c2.compare(x, y);
            }
        };
    }

    protected static class OppositeComparator
    implements LongComparator,
    Serializable {
        private static final long serialVersionUID = 1L;
        final LongComparator comparator;

        protected OppositeComparator(LongComparator c2) {
            this.comparator = c2;
        }

        @Override
        public final int compare(long a2, long b2) {
            return this.comparator.compare(b2, a2);
        }

        @Override
        public final LongComparator reversed() {
            return this.comparator;
        }
    }

    protected static class NaturalImplicitComparator
    implements LongComparator,
    Serializable {
        private static final long serialVersionUID = 1L;

        protected NaturalImplicitComparator() {
        }

        @Override
        public final int compare(long a2, long b2) {
            return Long.compare(a2, b2);
        }

        @Override
        public LongComparator reversed() {
            return OPPOSITE_COMPARATOR;
        }

        private Object readResolve() {
            return NATURAL_COMPARATOR;
        }
    }

    protected static class OppositeImplicitComparator
    implements LongComparator,
    Serializable {
        private static final long serialVersionUID = 1L;

        protected OppositeImplicitComparator() {
        }

        @Override
        public final int compare(long a2, long b2) {
            return -Long.compare(a2, b2);
        }

        @Override
        public LongComparator reversed() {
            return NATURAL_COMPARATOR;
        }

        private Object readResolve() {
            return OPPOSITE_COMPARATOR;
        }
    }
}

