/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit.fastutil.bytes;

import com.sk89q.worldedit.bukkit.fastutil.bytes.ByteComparator;
import java.io.Serializable;
import java.util.Comparator;

public final class ByteComparators {
    public static final ByteComparator NATURAL_COMPARATOR = new NaturalImplicitComparator();
    public static final ByteComparator OPPOSITE_COMPARATOR = new OppositeImplicitComparator();

    private ByteComparators() {
    }

    public static ByteComparator oppositeComparator(ByteComparator c2) {
        if (c2 instanceof OppositeComparator) {
            return ((OppositeComparator)c2).comparator;
        }
        return new OppositeComparator(c2);
    }

    public static ByteComparator asByteComparator(final Comparator<? super Byte> c2) {
        if (c2 == null || c2 instanceof ByteComparator) {
            return (ByteComparator)c2;
        }
        return new ByteComparator(){

            @Override
            public int compare(byte x, byte y) {
                return c2.compare(x, y);
            }

            @Override
            public int compare(Byte x, Byte y) {
                return c2.compare(x, y);
            }
        };
    }

    protected static class OppositeComparator
    implements ByteComparator,
    Serializable {
        private static final long serialVersionUID = 1L;
        final ByteComparator comparator;

        protected OppositeComparator(ByteComparator c2) {
            this.comparator = c2;
        }

        @Override
        public final int compare(byte a2, byte b2) {
            return this.comparator.compare(b2, a2);
        }

        @Override
        public final ByteComparator reversed() {
            return this.comparator;
        }
    }

    protected static class NaturalImplicitComparator
    implements ByteComparator,
    Serializable {
        private static final long serialVersionUID = 1L;

        protected NaturalImplicitComparator() {
        }

        @Override
        public final int compare(byte a2, byte b2) {
            return Byte.compare(a2, b2);
        }

        @Override
        public ByteComparator reversed() {
            return OPPOSITE_COMPARATOR;
        }

        private Object readResolve() {
            return NATURAL_COMPARATOR;
        }
    }

    protected static class OppositeImplicitComparator
    implements ByteComparator,
    Serializable {
        private static final long serialVersionUID = 1L;

        protected OppositeImplicitComparator() {
        }

        @Override
        public final int compare(byte a2, byte b2) {
            return -Byte.compare(a2, b2);
        }

        @Override
        public ByteComparator reversed() {
            return NATURAL_COMPARATOR;
        }

        private Object readResolve() {
            return OPPOSITE_COMPARATOR;
        }
    }
}

