/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit.fastutil.booleans;

import com.sk89q.worldedit.bukkit.fastutil.booleans.BooleanComparator;
import java.io.Serializable;
import java.util.Comparator;

public final class BooleanComparators {
    public static final BooleanComparator NATURAL_COMPARATOR = new NaturalImplicitComparator();
    public static final BooleanComparator OPPOSITE_COMPARATOR = new OppositeImplicitComparator();

    private BooleanComparators() {
    }

    public static BooleanComparator oppositeComparator(BooleanComparator c2) {
        if (c2 instanceof OppositeComparator) {
            return ((OppositeComparator)c2).comparator;
        }
        return new OppositeComparator(c2);
    }

    public static BooleanComparator asBooleanComparator(final Comparator<? super Boolean> c2) {
        if (c2 == null || c2 instanceof BooleanComparator) {
            return (BooleanComparator)c2;
        }
        return new BooleanComparator(){

            @Override
            public int compare(boolean x, boolean y) {
                return c2.compare(x, y);
            }

            @Override
            public int compare(Boolean x, Boolean y) {
                return c2.compare(x, y);
            }
        };
    }

    protected static class OppositeComparator
    implements BooleanComparator,
    Serializable {
        private static final long serialVersionUID = 1L;
        final BooleanComparator comparator;

        protected OppositeComparator(BooleanComparator c2) {
            this.comparator = c2;
        }

        @Override
        public final int compare(boolean a2, boolean b2) {
            return this.comparator.compare(b2, a2);
        }

        @Override
        public final BooleanComparator reversed() {
            return this.comparator;
        }
    }

    protected static class NaturalImplicitComparator
    implements BooleanComparator,
    Serializable {
        private static final long serialVersionUID = 1L;

        protected NaturalImplicitComparator() {
        }

        @Override
        public final int compare(boolean a2, boolean b2) {
            return Boolean.compare(a2, b2);
        }

        @Override
        public BooleanComparator reversed() {
            return OPPOSITE_COMPARATOR;
        }

        private Object readResolve() {
            return NATURAL_COMPARATOR;
        }
    }

    protected static class OppositeImplicitComparator
    implements BooleanComparator,
    Serializable {
        private static final long serialVersionUID = 1L;

        protected OppositeImplicitComparator() {
        }

        @Override
        public final int compare(boolean a2, boolean b2) {
            return -Boolean.compare(a2, b2);
        }

        @Override
        public BooleanComparator reversed() {
            return NATURAL_COMPARATOR;
        }

        private Object readResolve() {
            return OPPOSITE_COMPARATOR;
        }
    }
}

