/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extent.transform;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.AbstractDelegateExtent;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.math.transform.AffineTransform;
import com.sk89q.worldedit.math.transform.Transform;
import com.sk89q.worldedit.registry.state.BooleanProperty;
import com.sk89q.worldedit.registry.state.DirectionalProperty;
import com.sk89q.worldedit.registry.state.EnumProperty;
import com.sk89q.worldedit.registry.state.IntegerProperty;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import javax.annotation.Nullable;

public class BlockTransformExtent
extends AbstractDelegateExtent {
    private final Transform transform;
    private static final Set<String> directionNames = Sets.newHashSet((Object[])new String[]{"north", "south", "east", "west"});

    public BlockTransformExtent(Extent extent, Transform transform) {
        super(extent);
        Preconditions.checkNotNull((Object)transform);
        this.transform = transform;
    }

    public Transform getTransform() {
        return this.transform;
    }

    private <T extends BlockStateHolder<T>> T transformBlock(T block, boolean reverse) {
        return BlockTransformExtent.transform(block, reverse ? this.transform.inverse() : this.transform);
    }

    @Override
    public BlockState getBlock(BlockVector3 position) {
        return this.transformBlock(super.getBlock(position), false);
    }

    @Override
    public BaseBlock getFullBlock(BlockVector3 position) {
        return this.transformBlock(super.getFullBlock(position), false);
    }

    public <B extends BlockStateHolder<B>> boolean setBlock(BlockVector3 location, B block) throws WorldEditException {
        return super.setBlock(location, this.transformBlock(block, true));
    }

    public static <B extends BlockStateHolder<B>> B transform(B block, Transform transform) {
        Preconditions.checkNotNull(block);
        Preconditions.checkNotNull((Object)transform);
        if (transform.isIdentity()) {
            return block;
        }
        B result = block;
        List<Property<?>> properties = block.getBlockType().getProperties();
        for (Property<?> property : properties) {
            OptionalInt newRotation;
            Vector3 vec;
            if (property instanceof DirectionalProperty) {
                Vector3 newValue;
                DirectionalProperty dirProp = (DirectionalProperty)property;
                Direction value = (Direction)((Object)result.getState(property));
                if (value == null || (newValue = BlockTransformExtent.getNewStateValue(dirProp.getValues(), transform, value.toVector())) == null) continue;
                result = result.with(dirProp, (Direction)Direction.findClosest(newValue, Direction.Flag.ALL));
                continue;
            }
            if (property instanceof EnumProperty) {
                String[] parts;
                Object newValue;
                Object value;
                EnumProperty enumProp = (EnumProperty)property;
                if (property.getName().equals("axis")) {
                    String axis;
                    if ((value = (switch ((String)result.getState(property)) {
                        case "x" -> Direction.EAST;
                        case "y" -> Direction.UP;
                        case "z" -> Direction.NORTH;
                        default -> null;
                    })) == null || (newValue = BlockTransformExtent.getNewStateValue(Direction.valuesOf(Direction.Flag.UPRIGHT | Direction.Flag.CARDINAL), transform, ((Direction)((Object)value)).toVector())) == null) continue;
                    Direction newDir = Direction.findClosest((Vector3)newValue, Direction.Flag.UPRIGHT | Direction.Flag.CARDINAL);
                    if ((axis = (switch (newDir) {
                        case Direction.NORTH, Direction.SOUTH -> "z";
                        case Direction.EAST, Direction.WEST -> "x";
                        case Direction.UP, Direction.DOWN -> "y";
                        default -> null;
                    })) == null) continue;
                    result = result.with(enumProp, (String)axis);
                    continue;
                }
                if (property.getName().equals("type") && transform instanceof AffineTransform) {
                    AffineTransform affineTransform = (AffineTransform)transform;
                    if (affineTransform.isHorizontalFlip()) {
                        switch (value = (String)result.getState(property)) {
                            case "left": {
                                Object object = "right";
                                break;
                            }
                            case "right": {
                                Object object = "left";
                                break;
                            }
                            default: {
                                Object object = newValue = null;
                            }
                        }
                        if (newValue != null && enumProp.getValues().contains(newValue)) {
                            result = result.with(enumProp, (Object)newValue);
                        }
                    }
                    if (!affineTransform.isVerticalFlip()) continue;
                    if ((newValue = (switch (value = (String)result.getState(property)) {
                        case "bottom" -> "top";
                        case "top" -> "bottom";
                        default -> null;
                    })) == null || !enumProp.getValues().contains(newValue)) continue;
                    result = result.with(enumProp, (Object)newValue);
                    continue;
                }
                if (property.getName().equals("half") && transform instanceof AffineTransform) {
                    AffineTransform affineTransform = (AffineTransform)transform;
                    if (!affineTransform.isVerticalFlip()) continue;
                    if ((newValue = (switch (value = (String)result.getState(property)) {
                        case "bottom" -> "top";
                        case "top" -> "bottom";
                        default -> null;
                    })) == null || !enumProp.getValues().contains(newValue)) continue;
                    result = result.with(enumProp, (Object)newValue);
                    continue;
                }
                if (property.getName().equals("shape") && transform instanceof AffineTransform) {
                    String newStartString;
                    AffineTransform affineTransform = (AffineTransform)transform;
                    if (affineTransform.isHorizontalFlip()) {
                        switch (value = (String)result.getState(property)) {
                            case "outer_left": {
                                Object object = "outer_right";
                                break;
                            }
                            case "outer_right": {
                                Object object = "outer_left";
                                break;
                            }
                            case "inner_left": {
                                Object object = "inner_right";
                                break;
                            }
                            case "inner_right": {
                                Object object = "inner_left";
                                break;
                            }
                            default: {
                                Object object = newValue = null;
                            }
                        }
                        if (newValue != null && enumProp.getValues().contains(newValue)) {
                            result = result.with(enumProp, (Object)newValue);
                        }
                    }
                    if (!BlockTransformExtent.isRailShape(enumProp)) continue;
                    if (affineTransform.isVerticalFlip()) {
                        switch (value = (String)result.getState(property)) {
                            case "ascending_east": {
                                Object object = "ascending_west";
                                break;
                            }
                            case "ascending_west": {
                                Object object = "ascending_east";
                                break;
                            }
                            case "ascending_north": {
                                Object object = "ascending_south";
                                break;
                            }
                            case "ascending_south": {
                                Object object = "ascending_north";
                                break;
                            }
                            default: {
                                Object object = newValue = null;
                            }
                        }
                        if (newValue != null && enumProp.getValues().contains(newValue)) {
                            result = result.with(enumProp, (Object)newValue);
                        }
                    }
                    if (!(newStartString = (parts = ((String)(value = (String)result.getState(property))).split("_"))[0]).equals("ascending")) {
                        Direction start = Direction.valueOf(parts[0].toUpperCase(Locale.ROOT));
                        Vector3 newStartVec = transform.apply(start.toVector());
                        Direction newStart = Direction.findClosest(newStartVec, Direction.Flag.CARDINAL);
                        newStartString = newStart.toString().toLowerCase(Locale.ROOT);
                    }
                    Direction end = Direction.valueOf(parts[1].toUpperCase(Locale.ROOT));
                    Vector3 newEndVec = transform.apply(end.toVector());
                    Direction newEnd = Direction.findClosest(newEndVec, Direction.Flag.CARDINAL);
                    String newEndString = newEnd.toString().toLowerCase(Locale.ROOT);
                    String newShape = newStartString + "_" + newEndString;
                    String newShapeSwapped = newEndString + "_" + newStartString;
                    if (enumProp.getValues().contains(newShape)) {
                        result = result.with(enumProp, (CallSite)((Object)newShape));
                        continue;
                    }
                    if (!enumProp.getValues().contains(newShapeSwapped)) continue;
                    result = result.with(enumProp, (CallSite)((Object)newShapeSwapped));
                    continue;
                }
                if (!property.getName().equals("orientation") || !(transform instanceof AffineTransform)) continue;
                AffineTransform affineTransform = (AffineTransform)transform;
                String current = (String)result.getState(property);
                parts = current.split("_");
                Direction facing = Direction.valueOf(parts[0].toUpperCase(Locale.ROOT));
                Direction top = Direction.valueOf(parts[1].toUpperCase(Locale.ROOT));
                Vector3 newFacingVec = transform.apply(facing.toVector());
                Vector3 newTopVec = transform.apply(top.toVector());
                Direction newFacing = Direction.findClosest(newFacingVec, Direction.Flag.CARDINAL | Direction.Flag.UPRIGHT);
                Direction newTop = Direction.findClosest(newTopVec, Direction.Flag.CARDINAL | Direction.Flag.UPRIGHT);
                if (newTop.toString().equals(Direction.DOWN.toString())) {
                    newTop = Direction.UP;
                }
                String newOrientation = newFacing.toString().toLowerCase(Locale.ROOT) + "_" + newTop.toString().toLowerCase(Locale.ROOT);
                if (!enumProp.getValues().contains(newOrientation)) continue;
                result = result.with(enumProp, (CallSite)((Object)newOrientation));
                continue;
            }
            if (!(property instanceof IntegerProperty)) continue;
            IntegerProperty intProp = (IntegerProperty)property;
            if (!property.getName().equals("rotation") || intProp.getValues().size() != 16) continue;
            Optional<Direction> direction = Direction.fromRotationIndex(result.getState(intProp));
            int horizontalFlags = Direction.Flag.CARDINAL | Direction.Flag.ORDINAL | Direction.Flag.SECONDARY_ORDINAL;
            if (!direction.isPresent() || (vec = BlockTransformExtent.getNewStateValue(Direction.valuesOf(horizontalFlags), transform, direction.get().toVector())) == null || !(newRotation = Direction.findClosest(vec, horizontalFlags).toRotationIndex()).isPresent()) continue;
            result = result.with(intProp, newRotation.getAsInt());
        }
        HashMap<String, Boolean> directionalProperties = new HashMap<String, Boolean>();
        for (Property<?> prop : properties) {
            String origProp;
            Direction dir;
            Direction closest;
            if (!directionNames.contains(prop.getName())) continue;
            Object state = result.getState(prop);
            if ((!(prop instanceof BooleanProperty) || !((Boolean)state).booleanValue()) && (!(prop instanceof EnumProperty) || state.toString().equals("none")) || (closest = Direction.findClosest(transform.apply((dir = Direction.valueOf(origProp = prop.getName().toUpperCase(Locale.ROOT))).toVector()), Direction.Flag.CARDINAL)) == null) continue;
            String closestProp = closest.name().toLowerCase(Locale.ROOT);
            if (prop instanceof BooleanProperty) {
                result = result.with((BooleanProperty)prop, (Boolean)Boolean.FALSE);
                directionalProperties.put(closestProp, Boolean.TRUE);
                continue;
            }
            if (prop.getValues().contains("none")) {
                Property<?> propAsObj = prop;
                result = result.with(propAsObj, (String)"none");
            }
            directionalProperties.put(closestProp, (Boolean)state);
        }
        if (!directionalProperties.isEmpty()) {
            for (String directionName : directionNames) {
                Property dirProp = block.getBlockType().getProperty(directionName);
                result = result.with(dirProp, directionalProperties.get(directionName));
            }
        }
        return result;
    }

    @Nullable
    private static Vector3 getNewStateValue(List<Direction> allowedStates, Transform transform, Vector3 oldDirection) {
        Vector3 newDirection = transform.apply(oldDirection).subtract(transform.apply(Vector3.ZERO)).normalize();
        Vector3 newValue = null;
        double closest = -2.0;
        boolean found = false;
        for (Direction v : allowedStates) {
            double dot = v.toVector().normalize().dot(newDirection);
            if (!(dot >= closest)) continue;
            closest = dot;
            newValue = v.toVector();
            found = true;
        }
        if (found) {
            return newValue;
        }
        return null;
    }

    private static boolean isRailShape(EnumProperty property) {
        List propertyValues = property.getValues();
        List straightRailShapeValues = BlockTypes.DETECTOR_RAIL.getProperty("shape").getValues();
        if (propertyValues.size() < straightRailShapeValues.size()) {
            return false;
        }
        for (Object propertyValue : straightRailShapeValues) {
            if (propertyValues.contains(propertyValue)) continue;
            return false;
        }
        return true;
    }
}

