/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.util.profile.cache;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.enginehub.craftbook.util.profile.Profile;
import org.enginehub.craftbook.util.profile.cache.AbstractProfileCache;

public class HashMapCache
extends AbstractProfileCache {
    private final ConcurrentMap<UUID, String> cache = new ConcurrentHashMap<UUID, String>();

    @Override
    public void putAll(Iterable<Profile> profiles) {
        for (Profile profile : profiles) {
            this.cache.put(profile.getUniqueId(), profile.getName());
        }
    }

    @Override
    public ImmutableMap<UUID, Profile> getAllPresent(Iterable<UUID> uuids) {
        HashMap<UUID, Profile> results = new HashMap<UUID, Profile>();
        for (UUID uuid : uuids) {
            String name = (String)this.cache.get(uuid);
            if (name == null) continue;
            results.put(uuid, new Profile(uuid, name));
        }
        return ImmutableMap.copyOf(results);
    }
}

