/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.util.persistence;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataType;

public class UuidPersistentDataType
implements PersistentDataType<byte[], UUID> {
    public static final UuidPersistentDataType UUID_PERSISTENT_DATA_TYPE = new UuidPersistentDataType();

    public Class<byte[]> getPrimitiveType() {
        return byte[].class;
    }

    public Class<UUID> getComplexType() {
        return UUID.class;
    }

    public byte[] toPrimitive(UUID complex, PersistentDataAdapterContext context) {
        ByteBuffer buffer = ByteBuffer.wrap(new byte[16]);
        buffer.putLong(complex.getMostSignificantBits());
        buffer.putLong(complex.getLeastSignificantBits());
        return buffer.array();
    }

    public UUID fromPrimitive(byte[] primitive, PersistentDataAdapterContext context) {
        ByteBuffer buffer = ByteBuffer.wrap(primitive);
        long mostSig = buffer.getLong();
        long leastSig = buffer.getLong();
        return new UUID(mostSig, leastSig);
    }
}

