/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.util.persistence;

import java.util.UUID;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.TileState;
import org.bukkit.persistence.PersistentDataType;
import org.enginehub.craftbook.util.persistence.UuidPersistentDataType;
import org.jspecify.annotations.Nullable;

public class OwnedSignHelper {
    private static final NamespacedKey signOwnerKey = new NamespacedKey("craftbook", "owner");

    public static boolean hasOwner(Block block) {
        BlockState state = block.getState(false);
        return OwnedSignHelper.hasOwner(state);
    }

    public static boolean hasOwner(BlockState state) {
        if (state instanceof TileState) {
            TileState tileState = (TileState)state;
            return tileState.getPersistentDataContainer().has(signOwnerKey, (PersistentDataType)UuidPersistentDataType.UUID_PERSISTENT_DATA_TYPE);
        }
        return false;
    }

    public static @Nullable UUID getOwner(Block block) {
        BlockState state = block.getState(false);
        return OwnedSignHelper.getOwner(state);
    }

    public static @Nullable UUID getOwner(BlockState state) {
        if (state instanceof TileState) {
            TileState tileState = (TileState)state;
            return (UUID)tileState.getPersistentDataContainer().get(signOwnerKey, (PersistentDataType)UuidPersistentDataType.UUID_PERSISTENT_DATA_TYPE);
        }
        return null;
    }

    public static void setOwner(TileState tileState, @Nullable UUID owner) {
        if (owner == null) {
            tileState.getPersistentDataContainer().remove(signOwnerKey);
        } else {
            tileState.getPersistentDataContainer().set(signOwnerKey, (PersistentDataType)UuidPersistentDataType.UUID_PERSISTENT_DATA_TYPE, (Object)owner);
        }
    }
}

