/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.util.jinglenote.bukkit;

import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.entity.Player;
import org.enginehub.craftbook.util.SearchArea;
import org.enginehub.craftbook.util.jinglenote.Instrument;
import org.enginehub.craftbook.util.jinglenote.JingleNotePlayer;
import org.enginehub.craftbook.util.jinglenote.JingleSequencer;

public class BukkitJingleNotePlayer
extends JingleNotePlayer {
    private Player p = null;
    private static Sound BANJO;
    private static Sound BIT;
    private static Sound COWBELL;
    private static Sound DIDGERIDOO;
    private static Sound IRON_XYLOPHONE;

    public BukkitJingleNotePlayer(String player, JingleSequencer seq, SearchArea area) {
        super(player, seq, area);
    }

    @Override
    public void play(JingleSequencer.Note note) {
        if (!this.isPlaying()) {
            return;
        }
        this.p.playSound(this.p.getLocation(), BukkitJingleNotePlayer.toSound(note.getInstrument()), SoundCategory.RECORDS, note.getVelocity(), note.getNote());
    }

    @Override
    public boolean isPlaying() {
        if (this.p == null || !this.p.isOnline()) {
            this.p = Bukkit.getPlayerExact((String)this.player);
        }
        return this.p != null && this.p.isOnline() && (this.area == null || this.area.isWithinArea(this.p.getLocation())) && super.isPlaying();
    }

    private static Sound toSound(Instrument instrument) {
        switch (instrument) {
            case BASS: {
                return Sound.BLOCK_NOTE_BLOCK_BASS;
            }
            case SNARE: {
                return Sound.BLOCK_NOTE_BLOCK_SNARE;
            }
            case HAT: {
                return Sound.BLOCK_NOTE_BLOCK_HAT;
            }
            case BANJO: {
                return BANJO;
            }
            case BASEDRUM: {
                return Sound.BLOCK_NOTE_BLOCK_BASEDRUM;
            }
            case BELL: {
                return Sound.BLOCK_NOTE_BLOCK_BELL;
            }
            case BIT: {
                return BIT;
            }
            case CHIME: {
                return Sound.BLOCK_NOTE_BLOCK_CHIME;
            }
            case COW_BELL: {
                return COWBELL;
            }
            case DIDGERIDOO: {
                return DIDGERIDOO;
            }
            case FLUTE: {
                return Sound.BLOCK_NOTE_BLOCK_FLUTE;
            }
            case XYLOPHONE: {
                return Sound.BLOCK_NOTE_BLOCK_XYLOPHONE;
            }
            case IRON_XYLOPHONE: {
                return IRON_XYLOPHONE;
            }
            case PLING: {
                return Sound.BLOCK_NOTE_BLOCK_PLING;
            }
            case GUITAR: {
                return Sound.BLOCK_NOTE_BLOCK_GUITAR;
            }
        }
        return Sound.BLOCK_NOTE_BLOCK_HARP;
    }

    static {
        try {
            block16: for (Sound sound : (Sound[])Sound.class.getEnumConstants()) {
                switch (sound.name()) {
                    case "BLOCK_NOTE_BLOCK_BANJO": {
                        BANJO = sound;
                        continue block16;
                    }
                    case "BLOCK_NOTE_BLOCK_BIT": {
                        BIT = sound;
                        continue block16;
                    }
                    case "BLOCK_NOTE_BLOCK_COW_BELL": {
                        COWBELL = sound;
                        continue block16;
                    }
                    case "BLOCK_NOTE_BLOCK_DIDGERIDOO": {
                        DIDGERIDOO = sound;
                        continue block16;
                    }
                    case "BLOCK_NOTE_BLOCK_IRON_XYLOPHONE": {
                        IRON_XYLOPHONE = sound;
                    }
                }
            }
            if (BANJO == null) {
                throw new RuntimeException();
            }
        }
        catch (Throwable t) {
            BANJO = Sound.BLOCK_NOTE_BLOCK_GUITAR;
            BIT = Sound.BLOCK_NOTE_BLOCK_PLING;
            COWBELL = Sound.BLOCK_NOTE_BLOCK_BELL;
            DIDGERIDOO = Sound.BLOCK_NOTE_BLOCK_BASS;
            IRON_XYLOPHONE = Sound.BLOCK_NOTE_BLOCK_XYLOPHONE;
        }
    }
}

