/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.util.companion;

import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;

public class CompanionPlugins {
    private WorldEditPlugin worldEditPlugin;
    private Economy economy;
    private WorldGuardPlugin worldGuardPlugin;

    public void initiate(CraftBookPlugin plugin) {
        Plugin checkPlugin = plugin.getServer().getPluginManager().getPlugin("WorldEdit");
        if (checkPlugin instanceof WorldEditPlugin) {
            this.worldEditPlugin = (WorldEditPlugin)checkPlugin;
        } else {
            try {
                String string = "worldedit:cui";
            }
            catch (Throwable t) {
                plugin.getLogger().severe("WorldEdit detection has failed!");
                plugin.getLogger().severe("WorldEdit is a required dependency, Craftbook disabled!");
                return;
            }
        }
        checkPlugin = plugin.getServer().getPluginManager().getPlugin("WorldGuard");
        this.worldGuardPlugin = checkPlugin instanceof WorldGuardPlugin ? (WorldGuardPlugin)checkPlugin : null;
        try {
            RegisteredServiceProvider economyProvider = plugin.getServer().getServicesManager().getRegistration(Economy.class);
            this.economy = economyProvider != null ? (Economy)economyProvider.getProvider() : null;
        }
        catch (Throwable e) {
            this.economy = null;
        }
    }

    public Economy getEconomy() {
        return this.economy;
    }

    public WorldEditPlugin getWorldEdit() {
        return this.worldEditPlugin;
    }

    public WorldGuardPlugin getWorldGuard() {
        return this.worldGuardPlugin;
    }
}

