/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.util;

import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.WallSign;
import org.bukkit.block.sign.Side;
import org.bukkit.event.block.SignChangeEvent;
import org.jspecify.annotations.Nullable;

public final class SignUtil {
    private SignUtil() {
    }

    public static boolean isSign(Block block) {
        return Tag.ALL_SIGNS.isTagged((Keyed)block.getType());
    }

    public static boolean isStandingSign(Block block) {
        return Tag.STANDING_SIGNS.isTagged((Keyed)block.getType());
    }

    public static boolean isWallSign(Block block) {
        return SignUtil.isWallSign(block.getType());
    }

    public static boolean isWallSign(Material type) {
        return Tag.WALL_SIGNS.isTagged((Keyed)type);
    }

    public static BlockFace getFront(Block sign) {
        BlockData blockData = sign.getBlockData();
        if (blockData instanceof org.bukkit.block.data.type.Sign) {
            org.bukkit.block.data.type.Sign signBlock = (org.bukkit.block.data.type.Sign)blockData;
            return signBlock.getRotation();
        }
        if (blockData instanceof WallSign) {
            WallSign wallSign = (WallSign)blockData;
            return wallSign.getFacing();
        }
        return BlockFace.SELF;
    }

    public static Block getFrontBlock(Block sign) {
        return sign.getRelative(SignUtil.getFront(sign));
    }

    public static BlockFace getBack(Block sign) {
        return SignUtil.getFront(sign).getOppositeFace();
    }

    public static Block getBackBlock(Block sign) {
        return sign.getRelative(SignUtil.getBack(sign));
    }

    public static Block findNonSignBackBlock(Block sign) {
        Block backBlock;
        Block workingBlock = sign;
        while (SignUtil.isSign(workingBlock) && !(backBlock = SignUtil.getBackBlock(workingBlock)).equals((Object)workingBlock)) {
            workingBlock = backBlock;
        }
        return workingBlock;
    }

    public static @Nullable Block getNextSign(Block sign, String criterea, int searchRadius) {
        Block otherBlock = sign;
        BlockFace way = sign.getFace(SignUtil.getBackBlock(sign));
        boolean found = false;
        block0: for (int i = 0; i < searchRadius && !found; ++i) {
            if (SignUtil.isSign(otherBlock.getRelative(way))) {
                otherBlock = otherBlock.getRelative(way);
                Sign otherSign = (Sign)otherBlock.getState(false);
                for (Side side : Side.values()) {
                    if (!otherSign.getSide(side).getLine(1).equalsIgnoreCase(criterea)) continue;
                    found = true;
                    continue block0;
                }
                continue;
            }
            otherBlock = otherBlock.getRelative(way);
        }
        if (!found) {
            return null;
        }
        return otherBlock;
    }

    public static Block getRightBlock(Block sign) {
        return sign.getRelative(SignUtil.getRight(sign));
    }

    public static BlockFace getRight(Block sign) {
        return SignUtil.getCounterClockWise(SignUtil.getFront(sign));
    }

    public static Block getLeftBlock(Block sign) {
        return sign.getRelative(SignUtil.getLeft(sign));
    }

    public static BlockFace getLeft(Block sign) {
        return SignUtil.getClockWise(SignUtil.getFront(sign));
    }

    public static boolean isCardinal(Block sign) {
        BlockFace facing = SignUtil.getFront(sign);
        return switch (facing) {
            case BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST -> true;
            default -> false;
        };
    }

    public static BlockFace getClockWise(BlockFace face) {
        return switch (face) {
            case BlockFace.NORTH -> BlockFace.EAST;
            case BlockFace.EAST -> BlockFace.SOUTH;
            case BlockFace.SOUTH -> BlockFace.WEST;
            case BlockFace.WEST -> BlockFace.NORTH;
            default -> BlockFace.SELF;
        };
    }

    public static BlockFace getCounterClockWise(BlockFace face) {
        return switch (face) {
            case BlockFace.NORTH -> BlockFace.WEST;
            case BlockFace.EAST -> BlockFace.NORTH;
            case BlockFace.SOUTH -> BlockFace.EAST;
            case BlockFace.WEST -> BlockFace.SOUTH;
            default -> BlockFace.SELF;
        };
    }

    public static void cancelSignChange(SignChangeEvent event) {
        event.setCancelled(true);
        event.getBlock().breakNaturally();
    }
}

