/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.util;

import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;

public final class RedstoneUtil {
    private RedstoneUtil() {
    }

    public static Power isPowered(Block mechanicBlock, BlockFace face) {
        Block pow = mechanicBlock.getRelative(face);
        if (CraftBookPlugin.isDebugFlagEnabled("redstone")) {
            CraftBook.LOGGER.info("block " + String.valueOf(pow) + " power debug:");
            CraftBook.LOGGER.info("\tblock.isBlockPowered() : " + pow.isBlockPowered());
            CraftBook.LOGGER.info("\tblock.isBlockIndirectlyPowered() : " + pow.isBlockIndirectlyPowered());
            for (BlockFace bf : BlockFace.values()) {
                CraftBook.LOGGER.info("\tblock.isBlockFacePowered(" + String.valueOf(bf) + ") : " + pow.isBlockFacePowered(bf));
                CraftBook.LOGGER.info("\tblock.getFace(" + String.valueOf(bf) + ").isBlockPowered() : " + pow.getRelative(bf).isBlockPowered());
                CraftBook.LOGGER.info("\tblock.isBlockFaceIndirectlyPowered(" + String.valueOf(bf) + ") : " + pow.isBlockFaceIndirectlyPowered(bf));
                CraftBook.LOGGER.info("\tblock.getFace(" + String.valueOf(bf) + ").isBlockIndirectlyPowered(" + String.valueOf(bf) + ") : " + pow.getRelative(bf).isBlockIndirectlyPowered());
            }
            CraftBook.LOGGER.info("");
        }
        if (RedstoneUtil.isPotentialPowerSource(pow.getType())) {
            return pow.isBlockPowered() || pow.isBlockIndirectlyPowered() ? Power.ON : Power.OFF;
        }
        return Power.NA;
    }

    public static boolean isPotentialPowerSource(Material typeId) {
        return typeId == Material.REDSTONE_WIRE || typeId == Material.REPEATER || typeId == Material.LEVER || typeId == Material.REDSTONE_TORCH || typeId == Material.REDSTONE_WALL_TORCH || Tag.PRESSURE_PLATES.isTagged((Keyed)typeId) || typeId == Material.COMPARATOR || typeId == Material.REDSTONE_BLOCK;
    }

    public static enum Power {
        NA,
        ON,
        OFF;

    }
}

