/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.util;

import com.sk89q.worldedit.registry.Keyed;
import com.sk89q.worldedit.world.block.BlockCategories;
import com.sk89q.worldedit.world.block.BlockType;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.inventory.BlockInventoryHolder;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.mechanic.MechanicTypes;
import org.enginehub.craftbook.mechanics.minecart.blocks.CartMechanismBlocks;
import org.enginehub.craftbook.util.InventoryUtil;

public final class RailUtil {
    private RailUtil() {
    }

    public static List<BlockInventoryHolder> getNearbyInventoryBlocks(CartMechanismBlocks blocks) {
        ArrayList<Block> searchLocations = new ArrayList<Block>();
        if (blocks.hasBase()) {
            searchLocations.add(blocks.base());
        }
        if (blocks.hasRail()) {
            searchLocations.add(blocks.rail());
        }
        if (blocks.hasSign()) {
            searchLocations.add(blocks.sign());
        }
        ArrayList<BlockInventoryHolder> containers = new ArrayList<BlockInventoryHolder>();
        for (Block body : searchLocations) {
            int x = body.getX();
            int y = body.getY();
            int z = body.getZ();
            World world = body.getWorld();
            if (InventoryUtil.doesBlockHaveInventory(world.getBlockAt(x, y, z))) {
                containers.add((BlockInventoryHolder)world.getBlockAt(x, y, z).getState(false));
            }
            if (InventoryUtil.doesBlockHaveInventory(world.getBlockAt(x - 1, y, z))) {
                containers.add((BlockInventoryHolder)world.getBlockAt(x - 1, y, z).getState(false));
                if (InventoryUtil.doesBlockHaveInventory(world.getBlockAt(x - 2, y, z))) {
                    containers.add((BlockInventoryHolder)world.getBlockAt(x - 2, y, z).getState(false));
                }
            }
            if (InventoryUtil.doesBlockHaveInventory(world.getBlockAt(x + 1, y, z))) {
                containers.add((BlockInventoryHolder)world.getBlockAt(x + 1, y, z).getState(false));
                if (InventoryUtil.doesBlockHaveInventory(world.getBlockAt(x + 2, y, z))) {
                    containers.add((BlockInventoryHolder)world.getBlockAt(x + 2, y, z).getState(false));
                }
            }
            if (InventoryUtil.doesBlockHaveInventory(world.getBlockAt(x, y, z - 1))) {
                containers.add((BlockInventoryHolder)world.getBlockAt(x, y, z - 1).getState(false));
                if (InventoryUtil.doesBlockHaveInventory(world.getBlockAt(x, y, z - 2))) {
                    containers.add((BlockInventoryHolder)world.getBlockAt(x, y, z - 2).getState(false));
                }
            }
            if (!InventoryUtil.doesBlockHaveInventory(world.getBlockAt(x, y, z + 1))) continue;
            containers.add((BlockInventoryHolder)world.getBlockAt(x, y, z + 1).getState(false));
            if (!InventoryUtil.doesBlockHaveInventory(world.getBlockAt(x, y, z + 2))) continue;
            containers.add((BlockInventoryHolder)world.getBlockAt(x, y, z + 2).getState(false));
        }
        return containers;
    }

    public static boolean isTrack(BlockType blockType) {
        if (CraftBook.getInstance().getPlatform().getMechanicManager().getMechanic(MechanicTypes.MORE_RAILS.get()).map(moreRails -> moreRails.isValidRail(blockType)).orElse(false).booleanValue()) {
            return true;
        }
        return BlockCategories.RAILS.contains((Keyed)blockType);
    }
}

