/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.util;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.util.EventUtil;
import org.jspecify.annotations.Nullable;

public final class ProtectionUtil {
    private ProtectionUtil() {
    }

    public static boolean canBuild(Player player, Block block) {
        if (CraftBook.getInstance().getPlatform().getConfiguration().obeyWorldGuard && CraftBookPlugin.plugins.getWorldGuard() != null && !CraftBookPlugin.plugins.getWorldGuard().createProtectionQuery().testBlockPlace((Object)player, block.getLocation(), block.getType())) {
            return false;
        }
        if (CraftBook.getInstance().getPlatform().getConfiguration().obeyPluginProtections) {
            BlockPlaceEvent event = new BlockPlaceEvent(block, block.getState(), block.getRelative(0, -1, 0), player.getInventory().getItemInMainHand(), player, true, EquipmentSlot.HAND);
            EventUtil.callEventSafely((Event)event);
            return !event.isCancelled();
        }
        return true;
    }

    public static boolean canBreak(Player player, Block block) {
        if (CraftBook.getInstance().getPlatform().getConfiguration().obeyWorldGuard && CraftBookPlugin.plugins.getWorldGuard() != null && !CraftBookPlugin.plugins.getWorldGuard().createProtectionQuery().testBlockBreak((Object)player, block)) {
            return false;
        }
        if (CraftBook.getInstance().getPlatform().getConfiguration().obeyPluginProtections) {
            BlockBreakEvent event = new BlockBreakEvent(block, player);
            EventUtil.callEventSafely((Event)event);
            return !event.isCancelled();
        }
        return true;
    }

    public static boolean canSendCommand(Player player, String command) {
        if (CraftBook.getInstance().getPlatform().getConfiguration().obeyPluginProtections) {
            PlayerCommandPreprocessEvent event = new PlayerCommandPreprocessEvent(player, command);
            EventUtil.callEventSafely((Event)event);
            return !event.isCancelled();
        }
        return true;
    }

    public static boolean canUse(Player player, Location loc, @Nullable BlockFace face, @Nullable Action action) {
        if (CraftBook.getInstance().getPlatform().getConfiguration().obeyWorldGuard && CraftBookPlugin.plugins.getWorldGuard() != null && !CraftBookPlugin.plugins.getWorldGuard().createProtectionQuery().testBlockInteract((Object)player, loc.getBlock())) {
            return false;
        }
        if (CraftBook.getInstance().getPlatform().getConfiguration().obeyPluginProtections) {
            PlayerInteractEvent event = new PlayerInteractEvent(player, action == null ? Action.RIGHT_CLICK_BLOCK : action, player.getInventory().getItemInMainHand(), loc.getBlock(), face == null ? BlockFace.SELF : face);
            EventUtil.callEventSafely((Event)event);
            return !event.isCancelled();
        }
        return true;
    }

    public static boolean canAccessInventory(Player player, Block block) {
        return ProtectionUtil.canUse(player, block.getLocation(), null, Action.RIGHT_CLICK_BLOCK);
    }

    public static boolean canBlockForm(Block block, BlockState newState) {
        if (CraftBook.getInstance().getPlatform().getConfiguration().obeyWorldGuard && CraftBookPlugin.plugins.getWorldGuard() != null) {
            Material newType = newState.getType();
            if (newType == Material.SNOW || newType == Material.ICE || newType == Material.FROSTED_ICE) {
                RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
                RegionManager manager = container.get(BukkitAdapter.adapt((World)block.getWorld()));
                if (manager != null) {
                    StateFlag flag;
                    ApplicableRegionSet regionSet = manager.getApplicableRegions(BukkitAdapter.asBlockVector((Location)block.getLocation()));
                    switch (newType) {
                        case SNOW: {
                            StateFlag stateFlag = Flags.SNOW_FALL;
                            break;
                        }
                        case ICE: {
                            StateFlag stateFlag = Flags.ICE_FORM;
                            break;
                        }
                        case FROSTED_ICE: {
                            StateFlag stateFlag = Flags.FROSTED_ICE_FORM;
                            break;
                        }
                        default: {
                            StateFlag stateFlag = flag = null;
                        }
                    }
                    if (!regionSet.testState(null, new StateFlag[]{flag})) {
                        return false;
                    }
                }
            } else if (!CraftBookPlugin.plugins.getWorldGuard().createProtectionQuery().testBlockPlace(null, block.getLocation(), newType)) {
                return false;
            }
        }
        if (CraftBook.getInstance().getPlatform().getConfiguration().obeyPluginProtections) {
            BlockFormEvent event = new BlockFormEvent(block, newState);
            EventUtil.callEventSafely((Event)event);
            return !event.isCancelled();
        }
        return true;
    }

    public static boolean shouldUseProtection() {
        return CraftBook.getInstance().getPlatform().getConfiguration().obeyPluginProtections || CraftBook.getInstance().getPlatform().getConfiguration().obeyWorldGuard && CraftBookPlugin.plugins.getWorldGuard() != null;
    }
}

