/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.util;

import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;

public enum PlayerType {
    NAME('p'),
    UUID('u'),
    GROUP('g'),
    PERMISSION_NODE('n'),
    TEAM('t'),
    ALL('a');

    char prefix;

    private PlayerType(char prefix) {
        this.prefix = prefix;
    }

    public static PlayerType getFromChar(char c) {
        c = Character.toLowerCase(c);
        for (PlayerType t : PlayerType.values()) {
            if (t.prefix != c) continue;
            return t;
        }
        return NAME;
    }

    public boolean doesPlayerPass(Player player, String line) {
        switch (this.ordinal()) {
            case 2: {
                return CraftBookPlugin.inst().inGroup(player, line);
            }
            case 0: {
                return player.getName().toLowerCase(Locale.ENGLISH).startsWith(line.toLowerCase(Locale.ENGLISH));
            }
            case 1: {
                return player.getUniqueId().toString().toUpperCase(Locale.ENGLISH).startsWith(line.toUpperCase(Locale.ENGLISH));
            }
            case 3: {
                return player.hasPermission(line);
            }
            case 4: {
                try {
                    return Bukkit.getScoreboardManager().getMainScoreboard().getTeam(line).hasEntry(player.getName());
                }
                catch (Exception exception) {
                    break;
                }
            }
            case 5: {
                return true;
            }
            default: {
                return false;
            }
        }
        return false;
    }
}

