/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.util;

import com.sk89q.worldedit.math.Vector3;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.enginehub.craftbook.util.SignUtil;

public final class LocationUtil {
    public static final double EQUALS_PRECISION = 1.0E-4;

    private LocationUtil() {
    }

    public static boolean isWithinSphericalRadius(Location base, Location checked, double radius) {
        return base.getWorld() == checked.getWorld() && base.distanceSquared(checked) <= radius * radius;
    }

    public static boolean isWithinSphericalRadius(Block base, Block checked, double radius) {
        return LocationUtil.isWithinSphericalRadius(base.getLocation(), checked.getLocation(), radius + 0.5);
    }

    public static boolean isWithinRadiusPolygon(Location l1, Location l2, Vector3 radius) {
        if (!l1.getWorld().equals((Object)l2.getWorld())) {
            return false;
        }
        return l2.getX() < l1.getX() + radius.x() && l2.getX() > l1.getX() - radius.x() && l2.getY() < l1.getY() + radius.y() && l2.getY() > l1.getY() - radius.y() && l2.getZ() < l1.getZ() + radius.z() && l2.getZ() > l1.getZ() - radius.z();
    }

    public static boolean isWithinRadius(Location l1, Location l2, Vector3 radius) {
        return radius.x() == radius.z() && radius.x() == radius.y() && LocationUtil.isWithinSphericalRadius(l1, l2, radius.x()) || (radius.x() != radius.y() || radius.y() != radius.z() || radius.x() != radius.z()) && LocationUtil.isWithinRadiusPolygon(l1, l2, radius);
    }

    public static Block getRelativeOffset(Block sign, int offsetX, int offsetY, int offsetZ) {
        return LocationUtil.getRelativeOffset(SignUtil.getBackBlock(sign), SignUtil.getBack(sign), offsetX, offsetY, offsetZ);
    }

    public static Block getRelativeOffset(Block block, BlockFace front, int offsetX, int offsetY, int offsetZ) {
        BlockFace left;
        BlockFace back;
        BlockFace right = switch (front) {
            case BlockFace.SOUTH -> {
                back = BlockFace.NORTH;
                left = BlockFace.EAST;
                yield BlockFace.WEST;
            }
            case BlockFace.WEST -> {
                back = BlockFace.EAST;
                left = BlockFace.SOUTH;
                yield BlockFace.NORTH;
            }
            case BlockFace.NORTH -> {
                back = BlockFace.SOUTH;
                left = BlockFace.WEST;
                yield BlockFace.EAST;
            }
            case BlockFace.EAST -> {
                back = BlockFace.WEST;
                left = BlockFace.NORTH;
                yield BlockFace.SOUTH;
            }
            default -> {
                back = BlockFace.SOUTH;
                left = BlockFace.EAST;
                yield BlockFace.WEST;
            }
        };
        if (offsetX > 0) {
            block = block.getRelative(right, offsetX);
        } else if (offsetX < 0) {
            block = block.getRelative(left, offsetX);
        }
        if (offsetZ > 0) {
            block = block.getRelative(front, offsetZ);
        } else if (offsetZ < 0) {
            block = block.getRelative(back, offsetZ);
        }
        if (offsetY > 0) {
            block = block.getRelative(BlockFace.UP, offsetY);
        } else if (offsetY < 0) {
            block = block.getRelative(BlockFace.DOWN, offsetY);
        }
        return block;
    }

    public static Block getNextFreeSpace(Block block, BlockFace direction) {
        while (block.getType() != Material.AIR && block.getRelative(direction).getType() != Material.AIR && block.getY() < block.getWorld().getMaxHeight()) {
            block = block.getRelative(direction);
        }
        return block;
    }

    public static Location getBlockCentreTop(Block block) {
        return block.getLocation().add(0.5, 1.0, 0.5);
    }

    public static BlockFace[] getDirectFaces() {
        return new BlockFace[]{BlockFace.UP, BlockFace.DOWN, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST};
    }

    public static BlockFace[] getIndirectFaces() {
        return new BlockFace[]{BlockFace.UP, BlockFace.DOWN, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.NORTH_EAST, BlockFace.NORTH_WEST, BlockFace.SOUTH_EAST, BlockFace.SOUTH_WEST};
    }

    public static boolean equals(Location a, Location b) {
        return Math.abs(a.getX() - b.getX()) <= 1.0E-4 && Math.abs(a.getY() - b.getY()) <= 1.0E-4 && Math.abs(a.getZ() - b.getZ()) <= 1.0E-4;
    }

    public static float getYawFromFace(BlockFace blockFace) {
        double dx = blockFace.getModX();
        double dz = blockFace.getModZ();
        float yaw = 0.0f;
        if (dx != 0.0) {
            yaw = dx < 0.0 ? 4.712389f : 1.5707964f;
            yaw = (float)((double)yaw - Math.atan(dz / dx));
        } else if (dz < 0.0) {
            yaw = (float)Math.PI;
        }
        return -yaw * 180.0f / (float)Math.PI;
    }
}

