/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.blocks.BaseItem;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.extension.input.InputParseException;
import com.sk89q.worldedit.extension.input.ParserContext;
import com.sk89q.worldedit.world.registry.LegacyMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.mechanics.items.CommandItemDefinition;
import org.enginehub.craftbook.mechanics.items.CommandItems;

@Deprecated
public final class ItemSyntax {
    private static final Pattern ASTERISK_PATTERN = Pattern.compile("(?<=[^\\\\])([*])");
    private static final Pattern COLON_PATTERN = Pattern.compile("(?<=[^\\\\])([:])");
    private static final Pattern SEMICOLON_PATTERN = Pattern.compile("(?<=[^\\\\])([;])");
    private static final Pattern COMMA_PATTERN = Pattern.compile("(?<=[^\\\\])([,])");
    private static final Pattern PIPE_PATTERN = Pattern.compile("(?<=[^\\\\])([|])");
    private static final Pattern FSLASH_PATTERN = Pattern.compile("(?<=[^\\\\])([/])");
    private static final ParserContext ITEM_CONTEXT = new ParserContext();
    private static final LoadingCache<String, ItemStack> itemCache;

    private ItemSyntax() {
    }

    public static String getStringFromItem(ItemStack item) {
        StringBuilder builder = new StringBuilder();
        builder.append(item.getType().getKey().toString());
        if (item.hasItemMeta()) {
            ItemMeta meta = item.getItemMeta();
            if (meta.hasEnchants()) {
                for (Map.Entry enchants : meta.getEnchants().entrySet()) {
                    builder.append(';').append(((Enchantment)enchants.getKey()).getName()).append(':').append(enchants.getValue());
                }
            }
            if (meta.hasDisplayName()) {
                builder.append('|').append(meta.getDisplayName());
            }
            if (meta.hasLore()) {
                if (!meta.hasDisplayName()) {
                    builder.append("|$IGNORE");
                }
                List list = meta.getLore();
                for (String string : list) {
                    builder.append('|').append(string);
                }
            }
            if (meta.isUnbreakable()) {
                builder.append("/unbreakable:true");
            }
            ArrayList<String> flags = new ArrayList<String>();
            for (ItemFlag flag : ItemFlag.values()) {
                if (!meta.hasItemFlag(flag)) continue;
                flags.add(flag.name());
            }
            if (!flags.isEmpty()) {
                builder.append("/flags:").append(String.join((CharSequence)",", flags));
            }
            if (meta instanceof SkullMeta) {
                if (((SkullMeta)meta).hasOwner()) {
                    builder.append("/player:").append(((SkullMeta)meta).getOwner());
                }
            } else if (meta instanceof BookMeta) {
                if (((BookMeta)meta).hasTitle()) {
                    builder.append("/title:").append(((BookMeta)meta).getTitle());
                }
                if (((BookMeta)meta).hasAuthor()) {
                    builder.append("/author:").append(((BookMeta)meta).getAuthor());
                }
                if (((BookMeta)meta).hasPages()) {
                    for (String string : ((BookMeta)meta).getPages()) {
                        builder.append("/page:").append(string);
                    }
                }
            } else if (meta instanceof LeatherArmorMeta) {
                if (!((LeatherArmorMeta)meta).getColor().equals((Object)Bukkit.getItemFactory().getDefaultLeatherColor())) {
                    builder.append("/color:").append(((LeatherArmorMeta)meta).getColor().getRed()).append(',').append(((LeatherArmorMeta)meta).getColor().getGreen()).append(',').append(((LeatherArmorMeta)meta).getColor().getBlue());
                }
            } else if (meta instanceof PotionMeta) {
                if (!((PotionMeta)meta).hasCustomEffects()) {
                    for (PotionEffect potionEffect : ((PotionMeta)meta).getCustomEffects()) {
                        builder.append("/potion:").append(potionEffect.getType().getName()).append(';').append(potionEffect.getDuration()).append(';').append(potionEffect.getAmplifier());
                    }
                }
            } else if (meta instanceof EnchantmentStorageMeta) {
                if (!((EnchantmentStorageMeta)meta).hasStoredEnchants()) {
                    for (Map.Entry entry : ((EnchantmentStorageMeta)meta).getStoredEnchants().entrySet()) {
                        builder.append("/enchant:").append(((Enchantment)entry.getKey()).getKey().toString()).append(';').append(entry.getValue());
                    }
                }
            } else if (meta instanceof Damageable && ((Damageable)meta).getDamage() > 0) {
                builder.append("/damage:").append(((Damageable)meta).getDamage());
            }
        }
        return builder.toString().replace("\u00a7", "&");
    }

    public static ItemStack getItem(String line) {
        CommandItemDefinition def;
        if (line == null || line.isEmpty()) {
            return null;
        }
        if (CommandItems.INSTANCE != null && (def = CommandItems.INSTANCE.getDefinitionByName(line)) != null) {
            line = ItemSyntax.getStringFromItem(def.getItem());
        }
        return (ItemStack)itemCache.getUnchecked((Object)line);
    }

    static {
        ITEM_CONTEXT.setPreferringWildcard(true);
        ITEM_CONTEXT.setRestricted(false);
        itemCache = CacheBuilder.newBuilder().maximumSize(1024L).expireAfterAccess(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, ItemStack>(){

            public ItemStack load(String line) throws Exception {
                BaseItem item;
                String[] amountSplit;
                String[] enchantSplit;
                String[] nameLoreSplit;
                String[] advMetadataSplit;
                int amount;
                block35: {
                    amount = 1;
                    advMetadataSplit = FSLASH_PATTERN.split(line);
                    nameLoreSplit = PIPE_PATTERN.split(advMetadataSplit[0].replace("\\/", "/"));
                    enchantSplit = SEMICOLON_PATTERN.split(nameLoreSplit[0].replace("\\;", ";"));
                    amountSplit = ASTERISK_PATTERN.split(enchantSplit[0].replace("\\*", "*"), 2);
                    item = null;
                    try {
                        item = (BaseItem)WorldEdit.getInstance().getItemFactory().parseFromInput(amountSplit[0], ITEM_CONTEXT);
                    }
                    catch (InputParseException e) {
                        String[] dataSplit = COLON_PATTERN.split(amountSplit[0].replace("\\:", ":"), 2);
                        Material material = Material.getMaterial((String)dataSplit[0], (boolean)true);
                        if (material == null) break block35;
                        int data = 0;
                        if (dataSplit.length > 1 && ((data = Integer.parseInt(dataSplit[1])) < 0 || data > 15)) {
                            data = 0;
                        }
                        try {
                            int type = LegacyMapper.getInstance().getLegacyFromItem(BukkitAdapter.asItemType((Material)material))[0];
                            item = new BaseItem(LegacyMapper.getInstance().getItemFromLegacy(type, data));
                        }
                        catch (Exception ee) {
                            CraftBook.LOGGER.warn("Failed to convert legacy item: " + material.getId() + ":" + data);
                            ee.printStackTrace();
                        }
                    }
                }
                try {
                    if (amountSplit.length > 1) {
                        amount = Integer.parseInt(amountSplit[1]);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                ItemStack rVal = item == null || item.getType() == null ? new ItemStack(Material.STONE) : BukkitAdapter.adapt((BaseItemStack)new BaseItemStack(item.getType(), item.getNbtData(), amount));
                if (nameLoreSplit.length > 1) {
                    ItemMeta meta = rVal.getItemMeta();
                    meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)nameLoreSplit[1]));
                    if (nameLoreSplit.length > 2) {
                        ArrayList<String> lore = new ArrayList<String>();
                        for (int i = 2; i < nameLoreSplit.length; ++i) {
                            lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)nameLoreSplit[i]));
                        }
                        meta.setLore(lore);
                    }
                    rVal.setItemMeta(meta);
                }
                if (enchantSplit.length > 1) {
                    for (int i = 1; i < enchantSplit.length; ++i) {
                        try {
                            String[] sp = COLON_PATTERN.split(enchantSplit[i]);
                            Enchantment ench = Enchantment.getByName((String)sp[0]);
                            if (ench == null) {
                                ench = Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)sp[0]));
                            }
                            rVal.addUnsafeEnchantment(ench, Integer.parseInt(sp[1]));
                            continue;
                        }
                        catch (ArrayIndexOutOfBoundsException | NullPointerException | NumberFormatException sp) {
                            // empty catch block
                        }
                    }
                }
                if (advMetadataSplit.length > 1) {
                    ItemMeta meta = rVal.getItemMeta();
                    for (int i = 1; i < advMetadataSplit.length; ++i) {
                        String section = advMetadataSplit[i];
                        String[] bits = COLON_PATTERN.split(section, 2);
                        if (bits.length < 2) continue;
                        if (bits[0].equalsIgnoreCase("player") && meta instanceof SkullMeta) {
                            ((SkullMeta)meta).setOwner(bits[1]);
                            continue;
                        }
                        if (bits[0].equalsIgnoreCase("author") && meta instanceof BookMeta) {
                            ((BookMeta)meta).setAuthor(bits[1]);
                            continue;
                        }
                        if (bits[0].equalsIgnoreCase("title") && meta instanceof BookMeta) {
                            ((BookMeta)meta).setTitle(bits[1]);
                            continue;
                        }
                        if (bits[0].equalsIgnoreCase("page") && meta instanceof BookMeta) {
                            ((BookMeta)meta).addPage(new String[]{bits[1]});
                            continue;
                        }
                        if (bits[0].equalsIgnoreCase("color") && meta instanceof LeatherArmorMeta) {
                            String[] cols = COMMA_PATTERN.split(bits[1]);
                            ((LeatherArmorMeta)meta).setColor(Color.fromRGB((int)Integer.parseInt(cols[0]), (int)Integer.parseInt(cols[1]), (int)Integer.parseInt(cols[2])));
                            continue;
                        }
                        if (bits[0].equalsIgnoreCase("potion") && meta instanceof PotionMeta) {
                            String[] effects = SEMICOLON_PATTERN.split(bits[1]);
                            try {
                                PotionEffect effect = new PotionEffect(PotionEffectType.getByName((String)effects[0]), Integer.parseInt(effects[1]), Integer.parseInt(effects[2]));
                                ((PotionMeta)meta).addCustomEffect(effect, true);
                            }
                            catch (Exception effect) {}
                            continue;
                        }
                        if (bits[0].equalsIgnoreCase("enchant") && meta instanceof EnchantmentStorageMeta) {
                            try {
                                String[] sp = SEMICOLON_PATTERN.split(bits[1]);
                                Enchantment ench = Enchantment.getByName((String)sp[0]);
                                if (ench == null) {
                                    ench = Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)sp[0]));
                                }
                                ((EnchantmentStorageMeta)meta).addStoredEnchant(ench, Integer.parseInt(sp[1]), true);
                            }
                            catch (Exception sp) {}
                            continue;
                        }
                        if (bits[0].equalsIgnoreCase("unbreakable")) {
                            boolean unbreakable = Boolean.parseBoolean(bits[1]);
                            meta.setUnbreakable(unbreakable);
                            continue;
                        }
                        if (bits[0].equalsIgnoreCase("flags")) {
                            String[] flags;
                            for (String flag : flags = COMMA_PATTERN.split(bits[1])) {
                                meta.addItemFlags(new ItemFlag[]{ItemFlag.valueOf((String)flag)});
                            }
                            continue;
                        }
                        if (!bits[0].equalsIgnoreCase("damage") || !(meta instanceof Damageable)) continue;
                        try {
                            int damage = Integer.parseInt(bits[1]);
                            ((Damageable)meta).setDamage(damage);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    rVal.setItemMeta(meta);
                }
                return rVal;
            }
        });
    }
}

