/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.util;

import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.blocks.BaseItem;
import com.sk89q.worldedit.extension.input.InputParseException;
import com.sk89q.worldedit.extension.input.ParserContext;
import com.sk89q.worldedit.world.item.ItemType;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jspecify.annotations.Nullable;

public class ItemParser {
    private static final ParserContext ITEM_CONTEXT = new ParserContext();
    private static final Set<String> knownBadLines = new HashSet<String>();

    private ItemParser() {
    }

    public static @Nullable BaseItem getItem(@Nullable String line) {
        return ItemParser.getItem(line, false);
    }

    public static @Nullable BaseItem getItem(@Nullable String line, boolean wild) {
        if (line == null || line.trim().isEmpty() || knownBadLines.contains(line)) {
            return null;
        }
        ITEM_CONTEXT.setPreferringWildcard(wild);
        BaseItem baseItem = null;
        try {
            baseItem = (BaseItem)WorldEdit.getInstance().getItemFactory().parseFromInput(line, ITEM_CONTEXT);
        }
        catch (InputParseException e) {
            knownBadLines.add(line);
        }
        return baseItem;
    }

    public static List<BaseItem> getItems(List<String> lines) {
        return ItemParser.getItems(lines, false);
    }

    public static List<BaseItem> getItems(List<String> lines, boolean wild) {
        return lines.stream().map(line -> ItemParser.getItem(line, wild)).filter(Objects::nonNull).toList();
    }

    public static String toMinifiedId(ItemType holder) {
        String output = holder.id();
        if (output.startsWith("minecraft:")) {
            output = output.substring(10);
        }
        return output;
    }

    public static String toMinifiedId(BaseItem holder) {
        String output = holder.toString();
        if (output.startsWith("minecraft:")) {
            output = output.substring(10);
        }
        return output;
    }

    static {
        ITEM_CONTEXT.setTryLegacy(true);
        ITEM_CONTEXT.setRestricted(false);
    }
}

