/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BrewingStand;
import org.bukkit.block.Chest;
import org.bukkit.block.ChiseledBookshelf;
import org.bukkit.block.Crafter;
import org.bukkit.block.Furnace;
import org.bukkit.block.ShulkerBox;
import org.bukkit.inventory.BrewerInventory;
import org.bukkit.inventory.DoubleChestInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.enginehub.craftbook.util.ItemUtil;

public class InventoryUtil {
    private InventoryUtil() {
    }

    public static List<ItemStack> addItemsToInventory(InventoryHolder container, ItemStack ... stacks) {
        return InventoryUtil.addItemsToInventory(container, true, stacks);
    }

    public static List<ItemStack> addItemsToInventory(InventoryHolder container, boolean update, ItemStack ... stacks) {
        if (container instanceof Furnace) {
            return InventoryUtil.addItemsToFurnace((Furnace)container, stacks);
        }
        if (container instanceof BrewingStand) {
            return InventoryUtil.addItemsToBrewingStand((BrewingStand)container, stacks);
        }
        if (container instanceof Crafter) {
            return InventoryUtil.addItemsToCrafter((Crafter)container, stacks);
        }
        if (container instanceof ChiseledBookshelf) {
            return InventoryUtil.addItemsToChiseledBookshelf((ChiseledBookshelf)container, stacks);
        }
        ArrayList<ItemStack> leftovers = new ArrayList<ItemStack>();
        if (container instanceof ShulkerBox) {
            Arrays.stream(stacks).filter(item -> ItemUtil.isShulkerBox(item.getType())).forEach(leftovers::add);
            stacks = (ItemStack[])Arrays.stream(stacks).filter(item -> !ItemUtil.isShulkerBox(item.getType())).toArray(ItemStack[]::new);
        }
        leftovers.addAll(container.getInventory().addItem(stacks).values());
        if (container.getInventory() instanceof DoubleChestInventory) {
            ((Chest)((DoubleChestInventory)container.getInventory()).getLeftSide().getHolder()).update(true);
            ((Chest)((DoubleChestInventory)container.getInventory()).getRightSide().getHolder()).update(true);
        }
        return leftovers;
    }

    public static List<ItemStack> addItemsToFurnace(Furnace furnace, ItemStack ... stacks) {
        ArrayList<ItemStack> leftovers = new ArrayList<ItemStack>();
        for (ItemStack stack : stacks) {
            if (!ItemUtil.isStackValid(stack)) continue;
            if (furnace.getInventory().canSmelt(stack) && InventoryUtil.fitsInSlot(stack, furnace.getInventory().getSmelting())) {
                if (furnace.getInventory().getSmelting() == null) {
                    furnace.getInventory().setSmelting(stack);
                    continue;
                }
                leftovers.add(ItemUtil.addToStack(furnace.getInventory().getSmelting(), stack));
                continue;
            }
            if (furnace.getInventory().isFuel(stack) && InventoryUtil.fitsInSlot(stack, furnace.getInventory().getFuel())) {
                if (furnace.getInventory().getFuel() == null) {
                    furnace.getInventory().setFuel(stack);
                    continue;
                }
                leftovers.add(ItemUtil.addToStack(furnace.getInventory().getFuel(), stack));
                continue;
            }
            leftovers.add(stack);
        }
        leftovers.removeAll(Collections.singleton(null));
        return leftovers;
    }

    public static List<ItemStack> addItemsToBrewingStand(BrewingStand brewingStand, ItemStack ... stacks) {
        ArrayList<ItemStack> leftovers = new ArrayList<ItemStack>();
        for (ItemStack stack : stacks) {
            BrewerInventory inv = brewingStand.getInventory();
            if (ItemUtil.isAPotionIngredient(stack) && InventoryUtil.fitsInSlot(stack, inv.getIngredient())) {
                if (inv.getIngredient() == null) {
                    inv.setIngredient(stack);
                    continue;
                }
                leftovers.add(ItemUtil.addToStack(inv.getIngredient(), stack));
                continue;
            }
            if (stack.getType() == Material.BLAZE_POWDER && InventoryUtil.fitsInSlot(stack, inv.getFuel())) {
                if (inv.getFuel() == null) {
                    inv.setFuel(stack);
                    continue;
                }
                leftovers.add(ItemUtil.addToStack(inv.getFuel(), stack));
                continue;
            }
            if (stack.getType() == Material.GLASS_BOTTLE || stack.getType() == Material.POTION || stack.getType() == Material.LINGERING_POTION || stack.getType() == Material.SPLASH_POTION) {
                for (int i = 0; i < 3 && stack != null; ++i) {
                    if (inv.getItem(i) == null) {
                        inv.setItem(i, stack);
                        stack = null;
                        continue;
                    }
                    stack = ItemUtil.addToStack(inv.getItem(i), stack);
                }
                if (stack == null) continue;
                leftovers.add(stack);
                continue;
            }
            leftovers.add(stack);
        }
        return leftovers;
    }

    public static List<ItemStack> addItemsToCrafter(Crafter crafter, ItemStack ... stacks) {
        ArrayList<ItemStack> leftovers = new ArrayList<ItemStack>();
        int[] availableSlots = IntStream.rangeClosed(0, crafter.getInventory().getSize() - 1).filter(slot -> !crafter.isSlotDisabled(slot)).toArray();
        for (ItemStack stack : stacks) {
            Inventory inv = crafter.getInventory();
            for (int i : availableSlots) {
                if (stack == null) break;
                if (inv.getItem(i) == null) {
                    inv.setItem(i, stack);
                    stack = null;
                    continue;
                }
                stack = ItemUtil.addToStack(inv.getItem(i), stack);
            }
            if (stack == null) continue;
            leftovers.add(stack);
        }
        return leftovers;
    }

    public static List<ItemStack> addItemsToChiseledBookshelf(ChiseledBookshelf chiseledBookshelf, ItemStack ... stacks) {
        ArrayList<ItemStack> leftovers = new ArrayList<ItemStack>();
        Arrays.stream(stacks).filter(item -> !ItemUtil.isAStorableBook(item)).forEach(leftovers::add);
        stacks = (ItemStack[])Arrays.stream(stacks).filter(item -> ItemUtil.isAStorableBook(item)).toArray(ItemStack[]::new);
        leftovers.addAll(chiseledBookshelf.getInventory().addItem(stacks).values());
        return leftovers;
    }

    public static boolean doesInventoryContain(Inventory inv, boolean exact, ItemStack ... stacks) {
        return InventoryUtil.doesInventoryContain(inv, !exact, false, false, false, stacks);
    }

    public static boolean doesInventoryContain(Inventory inv, boolean ignoreStackSize, boolean ignoreDurability, boolean ignoreMeta, boolean ignoreEnchants, ItemStack ... stacks) {
        ArrayList<ItemStack> itemsToFind = new ArrayList<ItemStack>(Arrays.asList(stacks));
        if (itemsToFind.isEmpty()) {
            return true;
        }
        ArrayList<ItemStack> items = new ArrayList<ItemStack>(Arrays.asList(inv.getContents()));
        if (inv instanceof PlayerInventory) {
            items.addAll(Arrays.asList(((PlayerInventory)inv).getArmorContents()));
            items.add(((PlayerInventory)inv).getItemInOffHand());
        }
        block0: for (ItemStack item : items) {
            if (!ItemUtil.isStackValid(item)) continue;
            for (ItemStack base : stacks) {
                if (!itemsToFind.contains(base)) continue;
                if (!ItemUtil.isStackValid(base)) {
                    itemsToFind.remove(base);
                    continue;
                }
                if (base.getType() != item.getType() || !ignoreStackSize && base.getAmount() != item.getAmount() || !ignoreDurability && (base.getType().getMaxDurability() > 0 || item.getType().getMaxDurability() > 0) && base.getDurability() != item.getDurability() || !ignoreMeta && (base.hasItemMeta() != item.hasItemMeta() ? !ignoreEnchants || base.hasItemMeta() && ItemUtil.hasDisplayNameOrLore(base) || item.hasItemMeta() && ItemUtil.hasDisplayNameOrLore(item) : base.hasItemMeta() && base.hasItemMeta() && !ItemUtil.areItemMetaIdentical(base.getItemMeta(), item.getItemMeta(), !ignoreEnchants))) continue;
                itemsToFind.remove(base);
                continue block0;
            }
        }
        return itemsToFind.isEmpty();
    }

    public static boolean removeItemsFromInventory(InventoryHolder inv, ItemStack ... stacks) {
        ArrayList leftovers = new ArrayList(inv.getInventory().removeItemAnySlot(stacks).values());
        if (!leftovers.isEmpty()) {
            ArrayList<ItemStack> itemsToAdd = new ArrayList<ItemStack>(Arrays.asList(stacks));
            itemsToAdd.removeAll(leftovers);
            inv.getInventory().addItem(itemsToAdd.toArray(new ItemStack[itemsToAdd.size()]));
        }
        return leftovers.isEmpty();
    }

    public static boolean fitsInSlot(ItemStack stack, ItemStack slot) {
        return slot == null || ItemUtil.areItemsIdentical(stack, slot) && stack.getAmount() + slot.getAmount() <= stack.getMaxStackSize();
    }

    public static boolean doesBlockHaveInventory(Block block) {
        switch (block.getType()) {
            case CHEST: 
            case TRAPPED_CHEST: 
            case DROPPER: 
            case DISPENSER: 
            case FURNACE: 
            case BREWING_STAND: 
            case HOPPER: 
            case WHITE_SHULKER_BOX: 
            case ORANGE_SHULKER_BOX: 
            case MAGENTA_SHULKER_BOX: 
            case LIGHT_BLUE_SHULKER_BOX: 
            case YELLOW_SHULKER_BOX: 
            case GREEN_SHULKER_BOX: 
            case PINK_SHULKER_BOX: 
            case GRAY_SHULKER_BOX: 
            case LIGHT_GRAY_SHULKER_BOX: 
            case BLUE_SHULKER_BOX: 
            case PURPLE_SHULKER_BOX: 
            case CYAN_SHULKER_BOX: 
            case BROWN_SHULKER_BOX: 
            case LIME_SHULKER_BOX: 
            case BLACK_SHULKER_BOX: 
            case RED_SHULKER_BOX: 
            case SHULKER_BOX: 
            case BLAST_FURNACE: 
            case SMOKER: 
            case BARREL: 
            case CHISELED_BOOKSHELF: 
            case DECORATED_POT: 
            case CRAFTER: {
                return true;
            }
        }
        return false;
    }
}

