/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.util;

import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.regions.EllipsoidRegion;
import com.sk89q.worldedit.regions.RegionSelector;
import com.sk89q.worldedit.regions.selector.CuboidRegionSelector;
import com.sk89q.worldedit.regions.selector.SphereRegionSelector;
import com.sk89q.worldedit.session.SessionOwner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.kyori.adventure.text.TextReplacementConfig;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Switch;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.enginehub.craftbook.CraftBookPlayer;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.mechanics.ic.AbstractIC;
import org.enginehub.craftbook.mechanics.ic.ICMechanic;
import org.enginehub.craftbook.mechanics.ic.ICVerificationException;
import org.enginehub.craftbook.mechanics.pipe.PipeRequestEvent;
import org.enginehub.craftbook.util.InventoryUtil;
import org.enginehub.craftbook.util.LocationUtil;
import org.enginehub.craftbook.util.RegexUtil;
import org.enginehub.craftbook.util.SignUtil;
import org.enginehub.craftbook.util.VerifyUtil;

public final class ICUtil {
    private static final TextReplacementConfig OFF_REMOVER = (TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("[off]").replacement("").build();
    private static final TextReplacementConfig RAD_REMOVER = (TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("[rad]").replacement("").build();

    private ICUtil() {
    }

    public static boolean setState(Block block, boolean state, Block source) {
        if (block.getType() != Material.LEVER) {
            return false;
        }
        Switch lever = (Switch)block.getBlockData();
        if (!block.getRelative(lever.getFacing().getOppositeFace()).equals((Object)source)) {
            return false;
        }
        boolean wasOn = lever.isPowered();
        if (wasOn != state) {
            lever.setPowered(state);
            block.setBlockData((BlockData)lever);
            source.setBlockData(source.getBlockData(), true);
            BlockRedstoneEvent leverEvent = new BlockRedstoneEvent(block, wasOn ? 15 : 0, state ? 15 : 0);
            BlockRedstoneEvent sourceEvent = new BlockRedstoneEvent(source, wasOn ? 15 : 0, state ? 15 : 0);
            CraftBookPlugin.inst().getServer().getPluginManager().callEvent((Event)leverEvent);
            CraftBookPlugin.inst().getServer().getPluginManager().callEvent((Event)sourceEvent);
            return true;
        }
        return false;
    }

    public static void parseSignFlags(CraftBookPlayer player, BukkitChangedSign sign) {
        for (int i = 2; i < 4; ++i) {
            RegionSelector selector;
            String line = PlainTextComponentSerializer.plainText().serialize(sign.getLine(i));
            if (line.contains("[off]")) {
                if (CraftBookPlugin.plugins.getWorldEdit() == null) {
                    sign.setLine(i, sign.getLine(i).replaceText(OFF_REMOVER));
                    player.printError("worldedit.ic.notfound");
                } else {
                    selector = WorldEdit.getInstance().getSessionManager().get((SessionOwner)player).getRegionSelector(player.getWorld());
                    try {
                        if (selector instanceof CuboidRegionSelector) {
                            centre = selector.getRegion().getMaximumPoint().add(selector.getRegion().getMinimumPoint());
                            BlockVector3 offset = (centre = centre.divide(2)).subtract(BukkitAdapter.adapt((Location)sign.getBlock().getLocation()).toVector().toBlockPoint());
                            x = Double.toString(offset.x());
                            if (x.endsWith(".0")) {
                                x = x.replace(".0", "");
                            }
                            if ((y = Double.toString(offset.y())).endsWith(".0")) {
                                y = y.replace(".0", "");
                            }
                            if ((z = Double.toString(offset.z())).endsWith(".0")) {
                                z = z.replace(".0", "");
                            }
                            offsetReplacer = (TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("[off]").replacement("&" + x + ":" + y + ":" + z).build();
                            sign.setLine(i, sign.getLine(i).replaceText(offsetReplacer));
                        } else if (selector instanceof SphereRegionSelector) {
                            centre = selector.getRegion().getCenter();
                            Vector3 offset = centre.subtract(BukkitAdapter.adapt((Location)sign.getBlock().getLocation()).toVector());
                            x = Double.toString(offset.x());
                            if (x.endsWith(".0")) {
                                x = x.replace(".0", "");
                            }
                            if ((y = Double.toString(offset.y())).endsWith(".0")) {
                                y = y.replace(".0", "");
                            }
                            if ((z = Double.toString(offset.z())).endsWith(".0")) {
                                z = z.replace(".0", "");
                            }
                            offsetReplacer = (TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("[off]").replacement("&" + x + ":" + y + ":" + z).build();
                            sign.setLine(i, sign.getLine(i).replaceText(offsetReplacer));
                        } else {
                            sign.setLine(i, sign.getLine(i).replaceText(OFF_REMOVER));
                            player.printError("worldedit.ic.unsupported");
                        }
                    }
                    catch (IncompleteRegionException e) {
                        player.printError("worldedit.ic.noselection");
                    }
                }
            }
            if (!line.contains("[rad]")) continue;
            if (CraftBookPlugin.plugins.getWorldEdit() == null) {
                sign.setLine(i, sign.getLine(i).replaceText(RAD_REMOVER));
                player.printError("worldedit.ic.notfound");
                continue;
            }
            selector = WorldEdit.getInstance().getSessionManager().get((SessionOwner)player).getRegionSelector(player.getWorld());
            try {
                TextReplacementConfig radReplacer;
                String x;
                if (selector instanceof CuboidRegionSelector) {
                    String z;
                    String y;
                    x = Double.toString(Math.abs(selector.getRegion().getMaximumPoint().x() - selector.getRegion().getMinimumPoint().x()) / 2);
                    if (x.endsWith(".0")) {
                        x = x.replace(".0", "");
                    }
                    if ((y = Double.toString(Math.abs(selector.getRegion().getMaximumPoint().y() - selector.getRegion().getMinimumPoint().y()) / 2)).endsWith(".0")) {
                        y = y.replace(".0", "");
                    }
                    if ((z = Double.toString(Math.abs(selector.getRegion().getMaximumPoint().z() - selector.getRegion().getMinimumPoint().z()) / 2)).endsWith(".0")) {
                        z = z.replace(".0", "");
                    }
                    radReplacer = (TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("[rad]").replacement(x + "," + y + "," + z).build();
                    sign.setLine(i, sign.getLine(i).replaceText(radReplacer));
                    continue;
                }
                if (selector instanceof SphereRegionSelector) {
                    double amounts = ((EllipsoidRegion)selector.getRegion()).getRadius().x();
                    x = Double.toString(amounts);
                    if (x.endsWith(".0")) {
                        x = x.replace(".0", "");
                    }
                    radReplacer = (TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("[rad]").replacement(x).build();
                    sign.setLine(i, sign.getLine(i).replaceText(radReplacer));
                    continue;
                }
                sign.setLine(i, sign.getLine(i).replaceText(RAD_REMOVER));
                player.printError("worldedit.ic.unsupported");
                continue;
            }
            catch (IncompleteRegionException e) {
                player.printError("worldedit.ic.noselection");
            }
        }
        sign.update(false);
    }

    public static Vector3 parseUnsafeBlockLocation(String line) throws NumberFormatException, ArrayIndexOutOfBoundsException {
        String[] split;
        line = line.replace("!", "").replace("^", "").replace("&", "");
        double offsetX = 0.0;
        double offsetY = 0.0;
        double offsetZ = 0.0;
        if (line.contains("=")) {
            line = RegexUtil.EQUALS_PATTERN.split(line)[1];
        }
        if ((split = RegexUtil.COLON_PATTERN.split(line)).length > 1) {
            offsetX = Double.parseDouble(split[0]);
            offsetY = Double.parseDouble(split[1]);
            offsetZ = Double.parseDouble(split[2]);
        } else {
            offsetY = Double.parseDouble(line);
        }
        return Vector3.at((double)offsetX, (double)offsetY, (double)offsetZ);
    }

    public static Block parseBlockLocation(Block sign, String line, LocationCheckType relative) {
        Block target = SignUtil.getBackBlock(sign);
        if (line.contains("!")) {
            relative = LocationCheckType.getTypeFromChar('!');
        } else if (line.contains("^")) {
            relative = LocationCheckType.getTypeFromChar('^');
        } else if (line.contains("&")) {
            relative = LocationCheckType.getTypeFromChar('&');
        }
        BlockVector3 offsets = BlockVector3.ZERO;
        try {
            offsets = ICUtil.parseUnsafeBlockLocation(line).toBlockPoint();
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException runtimeException) {
            // empty catch block
        }
        if (offsets.x() == 0 && offsets.y() == 0 && offsets.z() == 0) {
            return target;
        }
        if (relative == LocationCheckType.RELATIVE) {
            target = LocationUtil.getRelativeOffset(sign, offsets.x(), offsets.y(), offsets.z());
        } else if (relative == LocationCheckType.OFFSET) {
            target = target.getRelative(offsets.x(), offsets.y(), offsets.z());
        } else if (relative == LocationCheckType.ABSOLUTE) {
            target = new Location(target.getWorld(), (double)offsets.x(), (double)offsets.y(), (double)offsets.z()).getBlock();
        }
        return target;
    }

    public static Block parseBlockLocation(BukkitChangedSign sign, int lPos, LocationCheckType relative) {
        return ICUtil.parseBlockLocation(sign.getBlock(), PlainTextComponentSerializer.plainText().serialize(sign.getLine(lPos)), relative);
    }

    public static Block parseBlockLocation(BukkitChangedSign sign, int lPos) {
        return ICUtil.parseBlockLocation(sign, lPos, ICMechanic.instance.defaultCoordinates);
    }

    public static Block parseBlockLocation(BukkitChangedSign sign) {
        return ICUtil.parseBlockLocation(sign, 2, ICMechanic.instance.defaultCoordinates);
    }

    public static void verifySignSyntax(BukkitChangedSign sign) throws ICVerificationException {
        ICUtil.verifySignLocationSyntax(sign, 2);
    }

    public static void verifySignLocationSyntax(BukkitChangedSign sign, int i) throws ICVerificationException {
        try {
            String[] strings;
            String line = PlainTextComponentSerializer.plainText().serialize(sign.getLine(i));
            line = line.replace("!", "").replace("^", "").replace("&", "");
            if (line.contains("=")) {
                String[] split = RegexUtil.EQUALS_PATTERN.split(line, 2);
                if (RegexUtil.COMMA_PATTERN.split(split[0]).length > 1) {
                    String[] rads = RegexUtil.COMMA_PATTERN.split(split[0]);
                    Double.parseDouble(rads[0]);
                    Double.parseDouble(rads[1]);
                    Double.parseDouble(rads[2]);
                } else {
                    Double.parseDouble(split[0]);
                }
                strings = RegexUtil.COLON_PATTERN.split(split[1], 3);
            } else {
                strings = RegexUtil.COLON_PATTERN.split(line);
            }
            if (strings.length > 1) {
                Double.parseDouble(strings[1]);
                Double.parseDouble(strings[2]);
            }
            Double.parseDouble(strings[0]);
        }
        catch (Exception e) {
            throw new ICVerificationException("Wrong syntax! Needs to be: radius=x:y:z or radius=y or y");
        }
    }

    public static Vector3 parseRadius(BukkitChangedSign sign) {
        return ICUtil.parseRadius(sign, 2);
    }

    public static Vector3 parseRadius(BukkitChangedSign sign, int lPos) {
        return ICUtil.parseRadius(PlainTextComponentSerializer.plainText().serialize(sign.getLine(lPos)));
    }

    public static Vector3 parseRadius(String line) {
        Vector3 radius = Vector3.at((double)10.0, (double)10.0, (double)10.0);
        try {
            radius = ICUtil.parseUnsafeRadius(line);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return radius;
    }

    public static Vector3 parseUnsafeRadius(String line) throws NumberFormatException {
        String[] radians = RegexUtil.COMMA_PATTERN.split(RegexUtil.EQUALS_PATTERN.split(line, 2)[0]);
        if (radians.length > 1) {
            double x = VerifyUtil.verifyRadius(Double.parseDouble(radians[0]), ICMechanic.instance.maxRange);
            double y = VerifyUtil.verifyRadius(Double.parseDouble(radians[1]), ICMechanic.instance.maxRange);
            double z = VerifyUtil.verifyRadius(Double.parseDouble(radians[2]), ICMechanic.instance.maxRange);
            return Vector3.at((double)x, (double)y, (double)z);
        }
        double r = Double.parseDouble(radians[0]);
        r = VerifyUtil.verifyRadius(r, ICMechanic.instance.maxRange);
        return Vector3.at((double)r, (double)r, (double)r);
    }

    public static void collectItem(AbstractIC ic, BlockVector3 offset, ItemStack ... items) {
        Sign sign = ic.getSign().getSign();
        Block backB = ic.getBackBlock();
        BlockFace back = SignUtil.getBack(sign.getBlock());
        Block pipe = backB.getRelative(back);
        PipeRequestEvent event = new PipeRequestEvent(pipe, new ArrayList<ItemStack>(Arrays.asList(items)), backB);
        Bukkit.getPluginManager().callEvent((Event)event);
        List<ItemStack> results = event.getItems();
        Block invHolder = backB.getRelative(offset.x(), offset.y(), offset.z());
        if (InventoryUtil.doesBlockHaveInventory(invHolder)) {
            InventoryHolder c = (InventoryHolder)invHolder.getState();
            results = InventoryUtil.addItemsToInventory(c, results.toArray(new ItemStack[0]));
        }
        for (ItemStack item : results) {
            backB.getWorld().dropItemNaturally(sign.getLocation().add(0.5, 0.0, 0.5), item);
        }
    }

    public static enum LocationCheckType {
        RELATIVE('^'),
        OFFSET('&'),
        ABSOLUTE('!');

        char c;

        private LocationCheckType(char c) {
            this.c = c;
        }

        public static LocationCheckType getTypeFromChar(char c) {
            for (LocationCheckType t : LocationCheckType.values()) {
                if (t.c != c) continue;
                return t;
            }
            return RELATIVE;
        }

        public static LocationCheckType getTypeFromName(String name) {
            if (name.length() == 1) {
                return LocationCheckType.getTypeFromChar(name.charAt(0));
            }
            for (LocationCheckType t : LocationCheckType.values()) {
                if (!t.name().equalsIgnoreCase(name)) continue;
                return t;
            }
            return RELATIVE;
        }
    }
}

