/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.util;

import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.enginehub.craftbook.CraftBook;

public final class EventUtil {
    private static final Set<Event> ignoredEvents = new HashSet<Event>();

    private EventUtil() {
    }

    public static void callEventSafely(Event event) {
        ignoredEvents.add(event);
        Bukkit.getPluginManager().callEvent(event);
        ignoredEvents.remove(event);
    }

    public static boolean shouldIgnoreEvent(Event ev) {
        return ignoredEvents.contains(ev);
    }

    public static boolean passesFilter(Event event) {
        Cancellable cancellable;
        if (CraftBook.getInstance().getPlatform().getConfiguration().obeyPluginProtections && event instanceof Cancellable && (cancellable = (Cancellable)event).isCancelled()) {
            return false;
        }
        return !EventUtil.shouldIgnoreEvent(event);
    }
}

