/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.util;

import java.util.ArrayList;
import java.util.Locale;

public final class EnumUtil {
    private EnumUtil() {
    }

    public static <T extends Enum<T>> T getEnumFromString(Class<T> c, String string) {
        if (c != null && string != null) {
            try {
                return Enum.valueOf(c, string.trim().toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String[] getStringArrayFromEnum(Class<? extends Enum<?>> c) {
        ArrayList<String> bits = new ArrayList<String>();
        for (Enum<?> s : c.getEnumConstants()) {
            bits.add(s.name());
        }
        return bits.toArray(new String[0]);
    }
}

