/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.util;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.bukkit.entity.Ambient;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Explosive;
import org.bukkit.entity.Horse;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Pig;
import org.bukkit.entity.Player;
import org.bukkit.entity.minecart.HopperMinecart;
import org.bukkit.entity.minecart.PoweredMinecart;
import org.bukkit.entity.minecart.RideableMinecart;
import org.bukkit.entity.minecart.StorageMinecart;
import org.enginehub.craftbook.util.EnumUtil;

public enum EntityType {
    PLAYER('P'),
    ITEM('I'),
    MOB_HOSTILE('H'),
    MOB_PEACEFUL('A'),
    MOB_ANY('M'),
    ANY('L'),
    CART('C'),
    RIDEABLE('R'),
    CART_STORAGE('S'),
    CART_POWERED('E'),
    CART_HOPPER('O'),
    EXPLOSIVE('T'),
    AMBIENT('N'),
    NON_LIVING('D'),
    LIVING('L');

    private final char shortName;

    public boolean is(Entity entity) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> entity instanceof Player;
            case 1 -> entity instanceof Item;
            case 2 -> {
                if (entity instanceof Monster && !(entity instanceof HumanEntity)) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (entity instanceof Animals && !(entity instanceof HumanEntity)) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                if (entity instanceof Mob && !(entity instanceof HumanEntity)) {
                    yield true;
                }
                yield false;
            }
            case 6 -> entity instanceof Minecart;
            case 8 -> entity instanceof StorageMinecart;
            case 9 -> entity instanceof PoweredMinecart;
            case 10 -> entity instanceof HopperMinecart;
            case 11 -> entity instanceof Explosive;
            case 7 -> {
                if (entity instanceof RideableMinecart || entity instanceof Boat || entity instanceof Pig || entity instanceof Horse) {
                    yield true;
                }
                yield false;
            }
            case 12 -> entity instanceof Ambient;
            case 13 -> {
                if (!(entity instanceof LivingEntity)) {
                    yield true;
                }
                yield false;
            }
            case 14 -> entity instanceof LivingEntity;
            case 5 -> true;
        };
    }

    private EntityType(char shortName) {
        this.shortName = shortName;
    }

    public char getCharName() {
        return this.shortName;
    }

    public static Set<EntityType> getDetected(String line) {
        HashSet<EntityType> types = new HashSet<EntityType>();
        if (line.trim().isEmpty()) {
            types.add(ANY);
            return types;
        }
        EntityType type = EnumUtil.getEnumFromString(EntityType.class, line);
        if (type != null) {
            types.add(type);
        } else {
            for (char aChar : line.toUpperCase(Locale.ENGLISH).toCharArray()) {
                for (EntityType aType : EntityType.values()) {
                    if (aType.shortName != aChar) continue;
                    types.add(aType);
                }
            }
        }
        if (types.isEmpty()) {
            types.add(ANY);
        }
        return types;
    }

    public static EntityType fromString(String name) {
        return EnumUtil.getEnumFromString(EntityType.class, name);
    }
}

