/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.util;

import com.sk89q.worldedit.math.BlockVector3;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.type.Snow;
import org.bukkit.inventory.ItemStack;
import org.enginehub.craftbook.util.LocationUtil;
import org.jspecify.annotations.Nullable;

public final class BlockUtil {
    private BlockUtil() {
    }

    public static boolean areBlocksIdentical(Block block, Block block2) {
        return block.getType() == block2.getType() && block.getBlockData().matches(block2.getBlockData());
    }

    public static boolean isBlockReplacable(Material id) {
        if (id.isAir() || Tag.REPLACEABLE.isTagged((Keyed)id)) {
            return true;
        }
        return switch (id) {
            case Material.FIRE, Material.LAVA, Material.WATER, Material.SNOW, Material.MOVING_PISTON -> true;
            default -> false;
        };
    }

    public static Location getBlockCentre(Block block) {
        return block.getLocation().add(0.5, 0.5, 0.5);
    }

    public static ItemStack[] getBlockDrops(Block block, @Nullable ItemStack tool) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        switch (block.getType()) {
            case SNOW: {
                if (tool == null || tool.getType() != Material.WOODEN_SHOVEL && tool.getType() != Material.STONE_SHOVEL && tool.getType() != Material.IRON_SHOVEL && tool.getType() != Material.GOLDEN_SHOVEL && tool.getType() != Material.DIAMOND_SHOVEL) break;
                drops.add(new ItemStack(Material.SNOWBALL, ((Snow)block.getBlockData()).getLayers() + 1));
                break;
            }
            case WHEAT: {
                drops.add(new ItemStack(Material.WHEAT, 1));
                int amount = ThreadLocalRandom.current().nextInt(4);
                if (amount <= 0) break;
                drops.add(new ItemStack(Material.WHEAT_SEEDS, amount));
                break;
            }
            case BEETROOTS: {
                drops.add(new ItemStack(Material.BEETROOT, 1));
                int amount = ThreadLocalRandom.current().nextInt(4);
                if (amount <= 0) break;
                drops.add(new ItemStack(Material.BEETROOT_SEEDS, amount));
                break;
            }
            case CARROTS: {
                drops.add(new ItemStack(Material.CARROT, 1 + ThreadLocalRandom.current().nextInt(4)));
                break;
            }
            case POTATOES: {
                drops.add(new ItemStack(Material.POTATO, 1 + ThreadLocalRandom.current().nextInt(4)));
                if (ThreadLocalRandom.current().nextInt(50) != 0) break;
                drops.add(new ItemStack(Material.POISONOUS_POTATO, 1));
                break;
            }
            case NETHER_WART: {
                drops.add(new ItemStack(Material.NETHER_WART, 2 + ThreadLocalRandom.current().nextInt(3)));
                break;
            }
            case SUGAR_CANE: {
                drops.add(new ItemStack(Material.SUGAR_CANE, 1));
                break;
            }
            case MELON: {
                drops.add(new ItemStack(Material.MELON_SLICE, 3 + ThreadLocalRandom.current().nextInt(5)));
                break;
            }
            case COCOA: {
                drops.add(new ItemStack(Material.COCOA_BEANS, 3));
                break;
            }
            default: {
                if (tool == null) {
                    drops.addAll(block.getDrops());
                    break;
                }
                drops.addAll(block.getDrops(tool));
            }
        }
        return drops.toArray(new ItemStack[0]);
    }

    public static List<Block> getTouchingBlocks(Block block) {
        BlockFace[] directFaces = LocationUtil.getDirectFaces();
        ArrayList<Block> blocks = new ArrayList<Block>(directFaces.length);
        for (BlockFace face : directFaces) {
            blocks.add(block.getRelative(face));
        }
        return blocks;
    }

    public static List<Block> getIndirectlyTouchingBlocks(Block block) {
        ArrayList<Block> blocks = new ArrayList<Block>(26);
        for (int x = -1; x < 2; ++x) {
            for (int y = -1; y < 2; ++y) {
                for (int z = -1; z < 2; ++z) {
                    if (x == 0 && y == 0 & z == 0) continue;
                    blocks.add(block.getRelative(x, y, z));
                }
            }
        }
        return blocks;
    }

    public static BlockVector3 toVector(BlockFace face) {
        return BlockVector3.at((int)face.getModX(), (int)face.getModY(), (int)face.getModZ());
    }
}

