/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.util;

import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.extension.input.InputParseException;
import com.sk89q.worldedit.extension.input.ParserContext;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jspecify.annotations.Nullable;

public class BlockParser {
    private static final ParserContext BLOCK_CONTEXT = new ParserContext();
    private static final Set<String> knownBadLines = new HashSet<String>();

    private BlockParser() {
    }

    public static @Nullable BaseBlock getBlock(@Nullable String line) {
        return BlockParser.getBlock(line, false);
    }

    public static @Nullable BaseBlock getBlock(@Nullable String line, boolean wild) {
        if (line == null || line.trim().isEmpty() || knownBadLines.contains(line)) {
            return null;
        }
        BLOCK_CONTEXT.setPreferringWildcard(wild);
        BaseBlock blockState = null;
        try {
            blockState = (BaseBlock)WorldEdit.getInstance().getBlockFactory().parseFromInput(line, BLOCK_CONTEXT);
        }
        catch (InputParseException e) {
            knownBadLines.add(line);
        }
        return blockState;
    }

    public static List<BaseBlock> getBlocks(List<String> lines) {
        return BlockParser.getBlocks(lines, false);
    }

    public static List<BaseBlock> getBlocks(List<String> lines, boolean wild) {
        return lines.stream().map(line -> BlockParser.getBlock(line, wild)).filter(Objects::nonNull).toList();
    }

    public static String toMinifiedId(BlockType holder) {
        String output = holder.id();
        if (output.startsWith("minecraft:")) {
            output = output.substring(10);
        }
        return output;
    }

    public static String toMinifiedId(BlockStateHolder<?> holder) {
        String output = holder.getAsString();
        if (output.startsWith("minecraft:")) {
            output = output.substring(10);
        }
        return output;
    }

    static {
        BLOCK_CONTEXT.setTryLegacy(true);
        BLOCK_CONTEXT.setRestricted(false);
    }
}

