/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanics.variables;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.extension.platform.Actor;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.enginehub.craftbook.AbstractCraftBookMechanic;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanics.variables.VariableKey;
import org.enginehub.craftbook.mechanics.variables.exception.VariableException;
import org.jspecify.annotations.Nullable;

public abstract class VariableManager
extends AbstractCraftBookMechanic {
    public static final Pattern ALLOWED_VALUE_PATTERN = Pattern.compile("[a-zA-Z0-9_]+");
    public static final Pattern VARIABLE_PATTERN = Pattern.compile("%(?:([a-zA-Z0-9_\\-]+)\\|)?([a-zA-Z0-9_]+)%");
    public static final Pattern DIRECT_VARIABLE_PATTERN = Pattern.compile("^(?:([a-zA-Z0-9_\\-]+)\\|)?([a-zA-Z0-9_]+)$");
    public static final String GLOBAL_NAMESPACE = "global";
    public static @Nullable VariableManager instance;
    protected final Map<String, Map<String, String>> variableStore = new ConcurrentHashMap<String, Map<String, String>>();
    protected boolean defaultToGlobal;
    protected boolean consoleOverride;
    protected boolean playerCommandOverride;
    protected boolean playerChatOverride;
    private int maxVariableSize;

    public VariableManager(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    public abstract void updateForVariableChange(VariableKey var1);

    public boolean hasVariable(VariableKey key) {
        Preconditions.checkNotNull((Object)key);
        Map<String, String> namespacedVariables = this.variableStore.getOrDefault(key.getNamespace(), (Map<String, String>)ImmutableMap.of());
        return namespacedVariables.containsKey(key.getVariable());
    }

    public @Nullable String getVariable(VariableKey key) {
        Preconditions.checkNotNull((Object)key);
        Map<String, String> namespacedVariables = this.variableStore.getOrDefault(key.getNamespace(), (Map<String, String>)ImmutableMap.of());
        return namespacedVariables.get(key.getVariable());
    }

    public void setVariable(VariableKey key, String value) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)value);
        Preconditions.checkArgument((value.length() <= this.maxVariableSize ? 1 : 0) != 0, (Object)"Variable value too large");
        Map namespacedVariables = this.variableStore.computeIfAbsent(key.getNamespace(), s -> Maps.newHashMap());
        namespacedVariables.put(key.getVariable(), value);
        this.updateForVariableChange(key);
    }

    public void removeVariable(VariableKey key) {
        Preconditions.checkNotNull((Object)key);
        Map<String, String> namespacedVariables = this.variableStore.get(key.getNamespace());
        if (namespacedVariables != null) {
            namespacedVariables.remove(key.getVariable());
            this.updateForVariableChange(key);
        }
    }

    public Map<String, Map<String, String>> getVariableStore() {
        return ImmutableMap.copyOf(this.variableStore);
    }

    public Collection<VariableKey> getPossibleVariables(Component line, @Nullable Actor actor) {
        return this.getPossibleVariables(PlainTextComponentSerializer.plainText().serialize(line), actor);
    }

    public Collection<VariableKey> getPossibleVariables(String line, @Nullable Actor actor) {
        if (!line.contains("%")) {
            return List.of();
        }
        HashSet<VariableKey> variables = new HashSet<VariableKey>();
        Matcher matcher = VARIABLE_PATTERN.matcher(line);
        while (matcher.find()) {
            String namespace = matcher.group(1);
            String key = matcher.group(2);
            try {
                variables.add(VariableKey.of(namespace, key, actor));
            }
            catch (VariableException variableException) {}
        }
        return variables;
    }

    public abstract Component renderVariables(Component var1, @Nullable Actor var2);

    public String renderVariables(String line, @Nullable Actor actor) {
        return PlainTextComponentSerializer.plainText().serialize(this.renderVariables((Component)Component.text((String)line), actor));
    }

    @Override
    public void loadFromConfiguration(YAMLProcessor config) {
        config.setComment("default-to-global", "Whether to default to global or the player's namespace when no namespace is provided");
        this.defaultToGlobal = config.getBoolean("default-to-global", false);
        config.setComment("enable-in-console", "Allows variables to work when used in console commands");
        this.consoleOverride = config.getBoolean("enable-in-console", false);
        config.setComment("enable-in-player-commands", "Allows variables to work when used in player commands");
        this.playerCommandOverride = config.getBoolean("enable-in-player-commands", false);
        config.setComment("enable-in-player-chat", "Allows variables to work when used in chat");
        this.playerChatOverride = config.getBoolean("enable-in-player-chat", false);
        config.setComment("max-variable-length", "The maximum length of a value in a variable");
        this.maxVariableSize = config.getInt("max-variable-length", 256);
    }
}

